/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.NotLevelEqualsRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class NotEqualsRule
extends AbstractRule {
    static final long serialVersionUID = -1135478467213793211L;
    private static final LoggingEventFieldResolver RESOLVER = LoggingEventFieldResolver.getInstance();
    private final String field;
    private final String value;

    private NotEqualsRule(String field, String value) {
        if (!RESOLVER.isField(field)) {
            throw new IllegalArgumentException("Invalid NOT EQUALS rule - " + field + " is not a supported field");
        }
        this.field = field;
        this.value = value;
    }

    public static Rule getRule(String field, String value) {
        if (field.equalsIgnoreCase("LEVEL")) {
            return NotLevelEqualsRule.getRule(value);
        }
        return new NotEqualsRule(field, value);
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid NOT EQUALS rule - expected two parameters but received " + stack.size());
        }
        String p2 = stack.pop().toString();
        String p1 = stack.pop().toString();
        if (p1.equalsIgnoreCase("LEVEL")) {
            return NotLevelEqualsRule.getRule(p2);
        }
        return new NotEqualsRule(p1, p2);
    }

    public boolean evaluate(LoggingEvent event, Map matches) {
        boolean result;
        Object p2 = RESOLVER.getValue(this.field, event);
        boolean bl = result = p2 != null && !p2.toString().equals(this.value);
        if (result && matches != null) {
            HashSet<String> entries = (HashSet<String>)matches.get(this.field.toUpperCase());
            if (entries == null) {
                entries = new HashSet<String>();
                matches.put(this.field.toUpperCase(), entries);
            }
            entries.add(this.value);
        }
        return result;
    }
}

