
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def StateAlarmExpression(vim, *args, **kwargs):
    '''An alarm expression that uses the running state of either a virtual machine or
    a host as the condition that triggers the alarm. Base type.There are two alarm
    operands: yellow and red. At least one of them must be set. The value of the
    alarm expression is determined as follows:'''

    obj = vim.client.factory.create('{urn:vim25}StateAlarmExpression')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 3:
        raise IndexError('Expected at least 4 arguments got: %d' % len(args))

    required = [ 'operator', 'statePath', 'type' ]
    optional = [ 'red', 'yellow', 'dynamicProperty', 'dynamicType' ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
