# Copyright (c) 2004-2022 Adam Karpierz
# Licensed under CC BY-NC-ND 4.0
# Licensed under proprietary License
# Please refer to the accompanying LICENSE file.

if __name__.rpartition(".")[-1] == "__main__":
    import sys
    import platform
    from pathlib import Path
    version_info = sys.version_info
    here = Path(__file__).resolve().parent
    prop_file = here/"version.properties"
    header = []
    with prop_file.open("rt") as fp:
        for line in fp:
            header.append(line)
            if not line.strip():
                break
    lines = header
    rlevels = {"alpha": 0xA, "beta": 0xB, "candidate": 0xC, "final": 0xF }
    lines.append("jvm.python.version={}\n".format(platform.python_version()))
    lines.append("jvm.python.major_version={}\n".format(version_info.major))
    lines.append("jvm.python.minor_version={}\n".format(version_info.minor))
    lines.append("jvm.python.micro_version={}\n".format(version_info.micro))
    lines.append("jvm.python.release_level={}\n".format(rlevels[version_info.releaselevel]))
    lines.append("jvm.python.release_serial={}\n".format(version_info.serial))
    lines.append("\n")
    lines.append("jvm.python.build.date={}\n".format(platform.python_build()[1][:11]))
    lines.append("jvm.python.build.time={}\n".format(platform.python_build()[1][-8:]))
    lines.append("\n")
    lines.append("jvm.python.build.hg_branch={}\n".format(platform.python_branch()))
    lines.append("jvm.python.build.hg_tag={}\n".format(""))
    lines.append("jvm.python.build.hg_version={}\n".format(platform.python_revision()))
    with prop_file.open("wt", newline="") as fp:
        fp.writelines(lines)

__javacode__ = bytearray(  # Auto-generated; DO NOT EDIT!
    b"\xca\xfe\xba\xbe\x00\x00\x00\x34\x00\xad\x0a\x00\x0c\x00\x57\x09\x00\x18\x00\x58"
    b"\x08\x00\x59\x09\x00\x18\x00\x5a\x0a\x00\x5b\x00\x5c\x08\x00\x5d\x09\x00\x18\x00"
    b"\x5e\x0a\x00\x18\x00\x5f\x08\x00\x60\x0a\x00\x18\x00\x61\x08\x00\x62\x07\x00\x63"
    b"\x09\x00\x18\x00\x64\x09\x00\x18\x00\x65\x0a\x00\x5b\x00\x66\x08\x00\x67\x08\x00"
    b"\x68\x0a\x00\x69\x00\x6a\x08\x00\x6b\x08\x00\x6c\x09\x00\x18\x00\x6d\x0a\x00\x18"
    b"\x00\x6e\x0a\x00\x18\x00\x6f\x07\x00\x70\x08\x00\x71\x0a\x00\x72\x00\x73\x07\x00"
    b"\x74\x0a\x00\x1b\x00\x57\x0a\x00\x1b\x00\x75\x08\x00\x76\x0a\x00\x1b\x00\x6a\x08"
    b"\x00\x77\x0a\x00\x78\x00\x79\x09\x00\x18\x00\x7a\x08\x00\x7b\x09\x00\x18\x00\x7c"
    b"\x08\x00\x7d\x09\x00\x18\x00\x7e\x08\x00\x7f\x09\x00\x18\x00\x80\x08\x00\x81\x09"
    b"\x00\x18\x00\x82\x08\x00\x83\x08\x00\x84\x08\x00\x85\x08\x00\x86\x08\x00\x87\x0a"
    b"\x00\x88\x00\x89\x07\x00\x8a\x09\x00\x69\x00\x8b\x08\x00\x8c\x0a\x00\x8d\x00\x8e"
    b"\x0a\x00\x31\x00\x8f\x07\x00\x90\x08\x00\x91\x0a\x00\x36\x00\x92\x0a\x00\x18\x00"
    b"\x93\x01\x00\x0a\x50\x59\x5f\x56\x45\x52\x53\x49\x4f\x4e\x01\x00\x12\x4c\x6a\x61"
    b"\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x01\x00\x10\x50\x59"
    b"\x5f\x4d\x41\x4a\x4f\x52\x5f\x56\x45\x52\x53\x49\x4f\x4e\x01\x00\x01\x49\x01\x00"
    b"\x10\x50\x59\x5f\x4d\x49\x4e\x4f\x52\x5f\x56\x45\x52\x53\x49\x4f\x4e\x01\x00\x10"
    b"\x50\x59\x5f\x4d\x49\x43\x52\x4f\x5f\x56\x45\x52\x53\x49\x4f\x4e\x01\x00\x10\x50"
    b"\x59\x5f\x52\x45\x4c\x45\x41\x53\x45\x5f\x4c\x45\x56\x45\x4c\x01\x00\x11\x50\x59"
    b"\x5f\x52\x45\x4c\x45\x41\x53\x45\x5f\x53\x45\x52\x49\x41\x4c\x01\x00\x04\x44\x41"
    b"\x54\x45\x01\x00\x04\x54\x49\x4d\x45\x01\x00\x09\x48\x47\x5f\x42\x52\x41\x4e\x43"
    b"\x48\x01\x00\x06\x48\x47\x5f\x54\x41\x47\x01\x00\x0a\x48\x47\x5f\x56\x45\x52\x53"
    b"\x49\x4f\x4e\x01\x00\x06\x3c\x69\x6e\x69\x74\x3e\x01\x00\x03\x28\x29\x56\x01\x00"
    b"\x04\x43\x6f\x64\x65\x01\x00\x0c\x67\x65\x74\x48\x47\x56\x65\x72\x73\x69\x6f\x6e"
    b"\x01\x00\x14\x28\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69"
    b"\x6e\x67\x3b\x01\x00\x0f\x67\x65\x74\x48\x47\x49\x64\x65\x6e\x74\x69\x66\x69\x65"
    b"\x72\x01\x00\x0d\x53\x74\x61\x63\x6b\x4d\x61\x70\x54\x61\x62\x6c\x65\x07\x00\x94"
    b"\x01\x00\x0c\x67\x65\x74\x42\x75\x69\x6c\x64\x49\x6e\x66\x6f\x01\x00\x05\x67\x65"
    b"\x74\x56\x4d\x01\x00\x0a\x67\x65\x74\x56\x65\x72\x73\x69\x6f\x6e\x01\x00\x0e\x6c"
    b"\x6f\x61\x64\x50\x72\x6f\x70\x65\x72\x74\x69\x65\x73\x07\x00\x95\x07\x00\x8a\x07"
    b"\x00\x96\x01\x00\x08\x3c\x63\x6c\x69\x6e\x69\x74\x3e\x0c\x00\x47\x00\x48\x0c\x00"
    b"\x46\x00\x3b\x01\x00\x00\x0c\x00\x45\x00\x3b\x07\x00\x94\x0c\x00\x97\x00\x98\x01"
    b"\x00\x03\x74\x69\x70\x0c\x00\x44\x00\x3b\x0c\x00\x4a\x00\x4b\x01\x00\x01\x3a\x0c"
    b"\x00\x4c\x00\x4b\x01\x00\x13\x25\x73\x25\x73\x25\x73\x2c\x20\x25\x2e\x32\x30\x73"
    b"\x2c\x20\x25\x2e\x39\x73\x01\x00\x10\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f"
    b"\x62\x6a\x65\x63\x74\x0c\x00\x42\x00\x3b\x0c\x00\x43\x00\x3b\x0c\x00\x99\x00\x9a"
    b"\x01\x00\x09\x5b\x25\x73\x20\x28\x25\x73\x29\x5d\x01\x00\x0c\x6a\x61\x76\x61\x2e"
    b"\x76\x6d\x2e\x6e\x61\x6d\x65\x07\x00\x9b\x0c\x00\x9c\x00\x9d\x01\x00\x0e\x6a\x61"
    b"\x76\x61\x2e\x76\x6d\x2e\x76\x65\x6e\x64\x6f\x72\x01\x00\x13\x25\x2e\x38\x30\x73"
    b"\x20\x28\x25\x2e\x38\x30\x73\x29\x0a\x25\x2e\x38\x30\x73\x0c\x00\x3a\x00\x3b\x0c"
    b"\x00\x4f\x00\x4b\x0c\x00\x50\x00\x4b\x01\x00\x12\x6f\x72\x67\x2f\x70\x79\x74\x68"
    b"\x6f\x6e\x2f\x56\x65\x72\x73\x69\x6f\x6e\x01\x00\x1e\x2f\x6f\x72\x67\x2f\x70\x79"
    b"\x74\x68\x6f\x6e\x2f\x76\x65\x72\x73\x69\x6f\x6e\x2e\x70\x72\x6f\x70\x65\x72\x74"
    b"\x69\x65\x73\x07\x00\x9e\x0c\x00\x9f\x00\xa0\x01\x00\x14\x6a\x61\x76\x61\x2f\x75"
    b"\x74\x69\x6c\x2f\x50\x72\x6f\x70\x65\x72\x74\x69\x65\x73\x0c\x00\xa1\x00\xa2\x01"
    b"\x00\x12\x6a\x76\x6d\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x76\x65\x72\x73\x69\x6f\x6e"
    b"\x01\x00\x18\x6a\x76\x6d\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x6d\x61\x6a\x6f\x72\x5f"
    b"\x76\x65\x72\x73\x69\x6f\x6e\x07\x00\xa3\x0c\x00\xa4\x00\xa5\x0c\x00\x3c\x00\x3d"
    b"\x01\x00\x18\x6a\x76\x6d\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x6d\x69\x6e\x6f\x72\x5f"
    b"\x76\x65\x72\x73\x69\x6f\x6e\x0c\x00\x3e\x00\x3d\x01\x00\x18\x6a\x76\x6d\x2e\x70"
    b"\x79\x74\x68\x6f\x6e\x2e\x6d\x69\x63\x72\x6f\x5f\x76\x65\x72\x73\x69\x6f\x6e\x0c"
    b"\x00\x3f\x00\x3d\x01\x00\x18\x6a\x76\x6d\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x72\x65"
    b"\x6c\x65\x61\x73\x65\x5f\x6c\x65\x76\x65\x6c\x0c\x00\x40\x00\x3d\x01\x00\x19\x6a"
    b"\x76\x6d\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x72\x65\x6c\x65\x61\x73\x65\x5f\x73\x65"
    b"\x72\x69\x61\x6c\x0c\x00\x41\x00\x3d\x01\x00\x15\x6a\x76\x6d\x2e\x70\x79\x74\x68"
    b"\x6f\x6e\x2e\x62\x75\x69\x6c\x64\x2e\x64\x61\x74\x65\x01\x00\x15\x6a\x76\x6d\x2e"
    b"\x70\x79\x74\x68\x6f\x6e\x2e\x62\x75\x69\x6c\x64\x2e\x74\x69\x6d\x65\x01\x00\x1a"
    b"\x6a\x76\x6d\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x62\x75\x69\x6c\x64\x2e\x68\x67\x5f"
    b"\x62\x72\x61\x6e\x63\x68\x01\x00\x17\x6a\x76\x6d\x2e\x70\x79\x74\x68\x6f\x6e\x2e"
    b"\x62\x75\x69\x6c\x64\x2e\x68\x67\x5f\x74\x61\x67\x01\x00\x1b\x6a\x76\x6d\x2e\x70"
    b"\x79\x74\x68\x6f\x6e\x2e\x62\x75\x69\x6c\x64\x2e\x68\x67\x5f\x76\x65\x72\x73\x69"
    b"\x6f\x6e\x07\x00\x95\x0c\x00\xa6\x00\x48\x01\x00\x13\x6a\x61\x76\x61\x2f\x69\x6f"
    b"\x2f\x49\x4f\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x0c\x00\xa7\x00\xa8\x01\x00\x3b"
    b"\x54\x68\x65\x72\x65\x20\x77\x61\x73\x20\x61\x20\x70\x72\x6f\x62\x6c\x65\x6d\x20"
    b"\x6c\x6f\x61\x64\x69\x6e\x67\x20\x2f\x6f\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f"
    b"\x76\x65\x72\x73\x69\x6f\x6e\x2e\x70\x72\x6f\x70\x65\x72\x74\x69\x65\x73\x3a\x07"
    b"\x00\xa9\x0c\x00\xaa\x00\xab\x0c\x00\xac\x00\x48\x01\x00\x1a\x6a\x61\x76\x61\x2f"
    b"\x6c\x61\x6e\x67\x2f\x52\x75\x6e\x74\x69\x6d\x65\x45\x78\x63\x65\x70\x74\x69\x6f"
    b"\x6e\x01\x00\x2d\x75\x6e\x61\x62\x6c\x65\x20\x74\x6f\x20\x6c\x6f\x61\x64\x20\x2f"
    b"\x6f\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x76\x65\x72\x73\x69\x6f\x6e\x2e\x70"
    b"\x72\x6f\x70\x65\x72\x74\x69\x65\x73\x0c\x00\x47\x00\xab\x0c\x00\x52\x00\x48\x01"
    b"\x00\x10\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x01\x00"
    b"\x13\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d"
    b"\x01\x00\x13\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x54\x68\x72\x6f\x77\x61\x62"
    b"\x6c\x65\x01\x00\x06\x65\x71\x75\x61\x6c\x73\x01\x00\x15\x28\x4c\x6a\x61\x76\x61"
    b"\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x29\x5a\x01\x00\x06\x66\x6f"
    b"\x72\x6d\x61\x74\x01\x00\x39\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53"
    b"\x74\x72\x69\x6e\x67\x3b\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62"
    b"\x6a\x65\x63\x74\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72"
    b"\x69\x6e\x67\x3b\x01\x00\x10\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x79\x73"
    b"\x74\x65\x6d\x01\x00\x0b\x67\x65\x74\x50\x72\x6f\x70\x65\x72\x74\x79\x01\x00\x26"
    b"\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29"
    b"\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x01\x00"
    b"\x0f\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x01\x00\x13\x67"
    b"\x65\x74\x52\x65\x73\x6f\x75\x72\x63\x65\x41\x73\x53\x74\x72\x65\x61\x6d\x01\x00"
    b"\x29\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b"
    b"\x29\x4c\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61"
    b"\x6d\x3b\x01\x00\x04\x6c\x6f\x61\x64\x01\x00\x18\x28\x4c\x6a\x61\x76\x61\x2f\x69"
    b"\x6f\x2f\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x3b\x29\x56\x01\x00\x11\x6a"
    b"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x49\x6e\x74\x65\x67\x65\x72\x01\x00\x08\x70"
    b"\x61\x72\x73\x65\x49\x6e\x74\x01\x00\x15\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e"
    b"\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x49\x01\x00\x05\x63\x6c\x6f\x73\x65\x01"
    b"\x00\x03\x65\x72\x72\x01\x00\x15\x4c\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x50\x72\x69"
    b"\x6e\x74\x53\x74\x72\x65\x61\x6d\x3b\x01\x00\x13\x6a\x61\x76\x61\x2f\x69\x6f\x2f"
    b"\x50\x72\x69\x6e\x74\x53\x74\x72\x65\x61\x6d\x01\x00\x07\x70\x72\x69\x6e\x74\x6c"
    b"\x6e\x01\x00\x15\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69"
    b"\x6e\x67\x3b\x29\x56\x01\x00\x0f\x70\x72\x69\x6e\x74\x53\x74\x61\x63\x6b\x54\x72"
    b"\x61\x63\x65\x00\x21\x00\x18\x00\x0c\x00\x00\x00\x0b\x00\x09\x00\x3a\x00\x3b\x00"
    b"\x00\x00\x09\x00\x3c\x00\x3d\x00\x00\x00\x09\x00\x3e\x00\x3d\x00\x00\x00\x09\x00"
    b"\x3f\x00\x3d\x00\x00\x00\x09\x00\x40\x00\x3d\x00\x00\x00\x09\x00\x41\x00\x3d\x00"
    b"\x00\x00\x09\x00\x42\x00\x3b\x00\x00\x00\x09\x00\x43\x00\x3b\x00\x00\x00\x09\x00"
    b"\x44\x00\x3b\x00\x00\x00\x09\x00\x45\x00\x3b\x00\x00\x00\x09\x00\x46\x00\x3b\x00"
    b"\x00\x00\x08\x00\x01\x00\x47\x00\x48\x00\x01\x00\x49\x00\x00\x00\x11\x00\x01\x00"
    b"\x01\x00\x00\x00\x05\x2a\xb7\x00\x01\xb1\x00\x00\x00\x00\x00\x09\x00\x4a\x00\x4b"
    b"\x00\x01\x00\x49\x00\x00\x00\x10\x00\x01\x00\x00\x00\x00\x00\x04\xb2\x00\x02\xb0"
    b"\x00\x00\x00\x00\x00\x09\x00\x4c\x00\x4b\x00\x01\x00\x49\x00\x00\x00\x3a\x00\x02"
    b"\x00\x00\x00\x00\x00\x20\x12\x03\xb2\x00\x04\xb6\x00\x05\x9a\x00\x0e\x12\x06\xb2"
    b"\x00\x04\xb6\x00\x05\x99\x00\x09\xb2\x00\x07\xa7\x00\x06\xb2\x00\x04\xb0\x00\x00"
    b"\x00\x01\x00\x4d\x00\x00\x00\x08\x00\x03\x16\x05\x42\x07\x00\x4e\x00\x09\x00\x4f"
    b"\x00\x4b\x00\x01\x00\x49\x00\x00\x00\x59\x00\x05\x00\x03\x00\x00\x00\x3b\xb8\x00"
    b"\x08\x4b\x12\x03\x2a\xb6\x00\x05\x99\x00\x08\x12\x03\xa7\x00\x05\x12\x09\x4c\xb8"
    b"\x00\x0a\x4d\x12\x0b\x08\xbd\x00\x0c\x59\x03\x2c\x53\x59\x04\x2b\x53\x59\x05\x2a"
    b"\x53\x59\x06\xb2\x00\x0d\x53\x59\x07\xb2\x00\x0e\x53\xb8\x00\x0f\xb0\x00\x00\x00"
    b"\x01\x00\x4d\x00\x00\x00\x0c\x00\x02\xfc\x00\x12\x07\x00\x4e\x41\x07\x00\x4e\x00"
    b"\x09\x00\x50\x00\x4b\x00\x01\x00\x49\x00\x00\x00\x26\x00\x05\x00\x00\x00\x00\x00"
    b"\x1a\x12\x10\x05\xbd\x00\x0c\x59\x03\x12\x11\xb8\x00\x12\x53\x59\x04\x12\x13\xb8"
    b"\x00\x12\x53\xb8\x00\x0f\xb0\x00\x00\x00\x00\x00\x09\x00\x51\x00\x4b\x00\x01\x00"
    b"\x49\x00\x00\x00\x28\x00\x05\x00\x00\x00\x00\x00\x1c\x12\x14\x06\xbd\x00\x0c\x59"
    b"\x03\xb2\x00\x15\x53\x59\x04\xb8\x00\x16\x53\x59\x05\xb8\x00\x17\x53\xb8\x00\x0f"
    b"\xb0\x00\x00\x00\x00\x00\x0a\x00\x52\x00\x48\x00\x01\x00\x49\x00\x00\x01\x4e\x00"
    b"\x03\x00\x06\x00\x00\x00\xcf\x03\x3b\x12\x18\x12\x19\xb6\x00\x1a\x4d\x2c\xc6\x00"
    b"\xb5\xbb\x00\x1b\x59\xb7\x00\x1c\x4e\x2d\x2c\xb6\x00\x1d\x04\x3b\x2d\x12\x1e\xb6"
    b"\x00\x1f\xb3\x00\x15\x2d\x12\x20\xb6\x00\x1f\xb8\x00\x21\xb3\x00\x22\x2d\x12\x23"
    b"\xb6\x00\x1f\xb8\x00\x21\xb3\x00\x24\x2d\x12\x25\xb6\x00\x1f\xb8\x00\x21\xb3\x00"
    b"\x26\x2d\x12\x27\xb6\x00\x1f\xb8\x00\x21\xb3\x00\x28\x2d\x12\x29\xb6\x00\x1f\xb8"
    b"\x00\x21\xb3\x00\x2a\x2d\x12\x2b\xb6\x00\x1f\xb3\x00\x0d\x2d\x12\x2c\xb6\x00\x1f"
    b"\xb3\x00\x0e\x2d\x12\x2d\xb6\x00\x1f\xb3\x00\x07\x2d\x12\x2e\xb6\x00\x1f\xb3\x00"
    b"\x04\x2d\x12\x2f\xb6\x00\x1f\xb3\x00\x02\x2c\xb6\x00\x30\xa7\x00\x2d\x4e\xa7\x00"
    b"\x29\x4e\xb2\x00\x32\x12\x33\xb6\x00\x34\x2d\xb6\x00\x35\x2c\xb6\x00\x30\xa7\x00"
    b"\x15\x4e\xa7\x00\x11\x3a\x04\x2c\xb6\x00\x30\xa7\x00\x05\x3a\x05\x19\x04\xbf\x1a"
    b"\x9a\x00\x0d\xbb\x00\x36\x59\x12\x37\xb7\x00\x38\xbf\xb1\x00\x07\x00\x8f\x00\x93"
    b"\x00\x96\x00\x31\x00\x0e\x00\x8f\x00\x9a\x00\x31\x00\xa7\x00\xab\x00\xae\x00\x31"
    b"\x00\x0e\x00\x8f\x00\xb2\x00\x00\x00\x9a\x00\xa7\x00\xb2\x00\x00\x00\xb4\x00\xb8"
    b"\x00\xbb\x00\x31\x00\xb2\x00\xb4\x00\xb2\x00\x00\x00\x01\x00\x4d\x00\x00\x00\x35"
    b"\x00\x08\xff\x00\x96\x00\x03\x01\x00\x07\x00\x53\x00\x01\x07\x00\x54\x43\x07\x00"
    b"\x54\x53\x07\x00\x54\x43\x07\x00\x55\xff\x00\x08\x00\x05\x01\x00\x07\x00\x53\x00"
    b"\x07\x00\x55\x00\x01\x07\x00\x54\x01\xf9\x00\x02\x0d\x00\x08\x00\x56\x00\x48\x00"
    b"\x01\x00\x49\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x04\xb8\x00\x39\xb1\x00"
    b"\x00\x00\x00\x00\x00"
)
