from collections import OrderedDict


class Dsl(object):
    buffer = {}
    es1 = False

    def __init__(self, es1=False):
        self.buffer = {}
        self.es1 = es1

    def dsl(self):
        return self.buffer

    def ui_query(self, **kwargs):
        if "multi_match" in kwargs:
            match = {"multi_match": {"query": kwargs["multi_match"], "fields": kwargs["fields"]}}
        else:
            match = {"match_all": {}}    # todo this is just a placeholder need to do something real here

        if "facets" in kwargs:
            kwargs.setdefault("filter", []).append(self.m_facet_filter(kwargs["facets"]))

        if "filter" in kwargs:
            if self.es1:
                query = {"query": {"filtered": {"query": match, "filter": kwargs["filter"]}}}
            else:
                query = {"query": {"bool": {"must": match, "filter": kwargs["filter"]}}}
        else:
            query = match
        self.buffer.update(query)
        return self

    def more_like_this(self, index, source):
        if self.es1:
            buffer = {"query": {"bool": {"should": source}}, "_source": ["id", "title", "scope"]}
        else:
            buffer = {
                    "_source": ["id", "title", "scope"],
                    "query": {
                        "more_like_this": {
                            "fields": ["keywords", "scope", "markup"],
                            "like": [{
                                "_index": index,
                                "_type": "articles",
                                "_id": source}],
                            "min_term_freq": 1,
                            "max_query_terms": 12
                            }}}
        self.buffer.update(buffer)
        return self

    def item_use(self, id):
        if self.es1:
            buffer = {"fields": ["id"], "query": {"term": {"items.item": id}}, "size": 1000}  # es1.4
        else:
            buffer = {"_source": ["id"], "query": {"term": {"items.item": id}}, "size": 1000}  # es5.2
        self.buffer.update(buffer)
        return self

    def associate_list(self, aType):
        buffer = {"query": {"term": {"type": aType}},
                  "_source": ["id", "title"]}
        self.buffer.update(buffer)
        return self

    def landing_list(self):
        buffer = {"_source": ["id", "title", "scope"],
                  "query": {"term": {"purpose": "landing"}},
                  "sort": {"id": "asc"}}
        self.buffer.update(buffer)
        return self

    def cluster_list(self, max=10000):
        buffer = {"size": "0",
                  "aggs": {
                             "clusters": {
                                "nested": {"path": "clusters"},
                                "aggs":  {"clusters":
                                          {"terms":
                                           {"field": "clusters.cluster", "order": {"_term": "asc"}, "size": max},
                                           "aggs": {
                                                        "sens": {
                                                            "reverse_nested": {},
                                                            "aggs": {"sens": {"terms": {"field": "sensitivity"}}}
                                                        }
                                                    }
                                           },
                                          "cluster_count": {"cardinality": {"field": "clusters.cluster"}}}
                                }}}
        self.buffer.update(buffer)
        return self

    def query_cluster(self, id):
        if self.es1:
            buffer = {"query": {"nested": {"path": "clusters", "filter": {"term": {"cluster": id}}}},
                      "fields": ["id", "title", "scope", "sensitivity"],
                      "sort": [{"clusters.priority": {
                                "order": "asc",
                                "nested_path": "clusters",
                                "nested_filter": {"term": {"clusters.cluster": id}}}}]}
        else:
            buffer = {"query": {"nested": {
                                    "path": "clusters",
                                    "query": {"bool": {"filter": {"term": {"clusters.cluster": id}}}}}},
                      "_source": ["id", "title", "scope", "sensitivity"],
                      "sort": [{"clusters.priority": {
                                "order": "asc",
                                "nested_path": "clusters",
                                "nested_filter": {"term": {"clusters.cluster": id}}}}]}
        self.buffer.update(buffer)
        return self

    def size(self, size, page=0):
        ctrl = {"size": int(size)}
        page = int(page)
        if page > 0:
            page = page - 1
            if page > 0:
                ctrl["from"] = page * ctrl["size"]
        self.buffer.update(ctrl)
        return self

# TODO shouldn't use kwargs
    def sort(self, **kwargs):
        sortmap = {"score": "_score", "popularity": "popularity", "date": "master.lastmodified"}
        sort = sortmap.get(kwargs.get("sort", "score"), "_score")
        # TODO need to get desc from input
        order = kwargs.get("order", "desc")
        self.buffer.update({"sort":  [{sort: {"order": order}}]})
        return self

    def suggest(self, data, source, max=10):
        self.buffer.update({"suggest": {"didyoumean": {"text": data, "term": {"field": source, "size": max}}}})
        return self

    def facets(self):
        self.buffer.update({"aggs": {
                              "nest":
                              {"nested":
                               {"path": "facets"},
                               "aggs": {"facetnames":
                                        {"terms":
                                         {"field": "facets.facet"},
                                         "aggs": {"focinames":
                                                  {"terms": {"field": "facets.foci"}}
                                                  }}}}}})
        return self

    def m_facet_filter(self, fociSelected):
        selected = OrderedDict()
        for items in fociSelected:
            facet_name, foci_name = items.split(',')
            if facet_name not in selected:
                selected[facet_name] = []
            selected[facet_name].append(foci_name)
        filters = []
        for fa, foci in selected.items():
            musts = [{"term": {"facets.facet": fa}}]

            for fo in foci:
                musts.append({"terms": {"facets.foci": [fo]}})
            if self.es1:
                facet = {"nested": {"path": "facets", "filter": {"bool": {"must": musts}}}}
            else:
                facet = {"nested": {"path": "facets", "query": {"bool": {"must": musts}}}}
            filters.append(facet)

        if self.es1:
            filter = {"and": {"filters": filters}}
        else:
            filter = {"bool": {"filter": filters}}
        return filter
