# HighwayHash CFFI

[HighwayHash](https://arxiv.org/abs/1612.06257) is a pseudorandom function (i.e. keyed hash function) optimized for speed on short messages, designed by Jyrki Alakuijala, Bill Cox and Jan Wassenberg of Google Research.

This package provides tested, performant **Python 3** CFFI bindings to the [HighwayHash reference implementation](https://github.com/google/highwayhash), including support for all output lengths.

# Installation

You can install this package using `pip` or the included `setup.py` script:

    # Using pip
    pip install highwayhash-cffi
    
    # Using setup.py
    python setup.py install

# Usage

```python
from highwayhash import *

# Demonstration key and data
key = b"\0" * 32
data = b"\0" * 64

# HighwayHash with a 64-bit output length
output = highwayhash_64(key, data)

# HighwayHash with a 128-bit output length
output = highwayhash_128(key, data)

# HighwayHash with a 256-bit output length
output = highwayhash_256(key, data)
```

# License
```text
BSD 3-Clause License

Copyright (c) 2018, Phil Demetriou
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
```