# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WebActivityAuthentication(Model):
    """Web activity authentication properties.

    :param type: Web activity authentication (Basic/ClientCertificate)
    :type type: str
    :param pfx: Base64-encoded contents of a PFX file.
    :type pfx: ~azure.mgmt.datafactory.models.SecureString
    :param username: Web activity authentication user name for basic
     authentication.
    :type username: str
    :param password: Password for the PFX file or basic authentication.
    :type password: ~azure.mgmt.datafactory.models.SecureString
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'pfx': {'key': 'pfx', 'type': 'SecureString'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'SecureString'},
    }

    def __init__(self, type, pfx=None, username=None, password=None):
        self.type = type
        self.pfx = pfx
        self.username = username
        self.password = password
