# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset_storage_format import DatasetStorageFormat


class JsonFormat(DatasetStorageFormat):
    """The data stored in JSON format.

    :param serializer: Serializer. Type: string (or Expression with resultType
     string).
    :type serializer: object
    :param deserializer: Deserializer. Type: string (or Expression with
     resultType string).
    :type deserializer: object
    :param type: Constant filled by server.
    :type type: str
    :param file_pattern: File pattern of JSON. To be more specific, the way of
     separating a collection of JSON objects. The default value is
     'setOfObjects'. It is case-sensitive. Possible values include:
     'setOfObjects', 'arrayOfObjects'
    :type file_pattern: str or
     ~azure.mgmt.datafactory.models.JsonFormatFilePattern
    :param nesting_separator: The character used to separate nesting levels.
     Default value is '.' (dot). Type: string (or Expression with resultType
     string).
    :type nesting_separator: object
    :param encoding_name: The code page name of the preferred encoding. If not
     provided, the default value is 'utf-8', unless the byte order mark (BOM)
     denotes another Unicode encoding. The full list of supported values can be
     found in the 'Name' column of the table of encodings in the following
     reference:
     https://msdn.microsoft.com/library/system.text.encoding.aspx#Anchor_5.
     Type: string (or Expression with resultType string).
    :type encoding_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
        'type': {'key': 'type', 'type': 'str'},
        'file_pattern': {'key': 'filePattern', 'type': 'str'},
        'nesting_separator': {'key': 'nestingSeparator', 'type': 'object'},
        'encoding_name': {'key': 'encodingName', 'type': 'object'},
    }

    def __init__(self, serializer=None, deserializer=None, file_pattern=None, nesting_separator=None, encoding_name=None):
        super(JsonFormat, self).__init__(serializer=serializer, deserializer=deserializer)
        self.file_pattern = file_pattern
        self.nesting_separator = nesting_separator
        self.encoding_name = encoding_name
        self.type = 'JsonFormat'
