# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IntegrationRuntimeComputeProperties(Model):
    """The compute resource properties for managed integration runtime.

    :param location: The location for managed integration runtime. The
     supported regions could be found on
     https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
    :type location: str
    :param node_size: The node size requirement to managed integration
     runtime.
    :type node_size: str
    :param number_of_nodes: The required number of nodes for managed
     integration runtime.
    :type number_of_nodes: int
    :param max_parallel_executions_per_node: Maximum parallel executions count
     per node for managed integration runtime.
    :type max_parallel_executions_per_node: int
    :param v_net_properties: VNet properties for managed integration runtime.
    :type v_net_properties:
     ~azure.mgmt.datafactory.models.IntegrationRuntimeVNetProperties
    """

    _validation = {
        'number_of_nodes': {'minimum': 1},
        'max_parallel_executions_per_node': {'maximum': 8, 'minimum': 1},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'node_size': {'key': 'nodeSize', 'type': 'str'},
        'number_of_nodes': {'key': 'numberOfNodes', 'type': 'int'},
        'max_parallel_executions_per_node': {'key': 'maxParallelExecutionsPerNode', 'type': 'int'},
        'v_net_properties': {'key': 'vNetProperties', 'type': 'IntegrationRuntimeVNetProperties'},
    }

    def __init__(self, location=None, node_size=None, number_of_nodes=None, max_parallel_executions_per_node=None, v_net_properties=None):
        self.location = location
        self.node_size = node_size
        self.number_of_nodes = number_of_nodes
        self.max_parallel_executions_per_node = max_parallel_executions_per_node
        self.v_net_properties = v_net_properties
