# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .control_activity import ControlActivity


class ExecutePipelineActivity(ControlActivity):
    """Execute pipeline activity.

    :param name: Activity name.
    :type name: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param type: Constant filled by server.
    :type type: str
    :param pipeline: Pipeline reference.
    :type pipeline: ~azure.mgmt.datafactory.models.PipelineReference
    :param parameters: Pipeline parameters.
    :type parameters: dict[str, object]
    :param wait_on_completion: Defines whether activity execution will wait
     for the dependent pipeline execution to finish. Default is false.
    :type wait_on_completion: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'pipeline': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'type': {'key': 'type', 'type': 'str'},
        'pipeline': {'key': 'typeProperties.pipeline', 'type': 'PipelineReference'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'wait_on_completion': {'key': 'typeProperties.waitOnCompletion', 'type': 'bool'},
    }

    def __init__(self, name, pipeline, description=None, depends_on=None, parameters=None, wait_on_completion=None):
        super(ExecutePipelineActivity, self).__init__(name=name, description=description, depends_on=depends_on)
        self.pipeline = pipeline
        self.parameters = parameters
        self.wait_on_completion = wait_on_completion
        self.type = 'ExecutePipeline'
