# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureMLWebServiceFile(Model):
    """Azure ML WebService Input/Output file.

    :param file_path: The relative file path, including container name, in the
     Azure Blob Storage specified by the LinkedService. Type: string (or
     Expression with resultType string).
    :type file_path: object
    :param linked_service_name: Reference to an Azure Storage LinkedService,
     where Azure ML WebService Input/Output file located.
    :type linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'file_path': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'file_path': {'key': 'filePath', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
    }

    def __init__(self, file_path, linked_service_name):
        self.file_path = file_path
        self.linked_service_name = linked_service_name
