# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset import Dataset


class AzureDataLakeStoreDataset(Dataset):
    """Azure Data Lake Store dataset.

    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type:
     array (or Expression with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param linked_service_name: Linked service reference.
    :type linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str,
     ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param type: Constant filled by server.
    :type type: str
    :param folder_path: Path to the folder in the Azure Data Lake Store. Type:
     string (or Expression with resultType string).
    :type folder_path: object
    :param file_name: The name of the file in the Azure Data Lake Store. Type:
     string (or Expression with resultType string).
    :type file_name: object
    :param format: The format of the Data Lake Store.
    :type format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :param compression: The data compression method used for the item(s) in
     the Azure Data Lake Store.
    :type compression: ~azure.mgmt.datafactory.models.DatasetCompression
    :param partitioned_by: Specify a dynamic path and filename for time series
     data.
    :type partitioned_by:
     list[~azure.mgmt.datafactory.models.DatasetPartition]
    """

    _validation = {
        'linked_service_name': {'required': True},
        'type': {'required': True},
        'folder_path': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'file_name': {'key': 'typeProperties.fileName', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
        'partitioned_by': {'key': 'typeProperties.partitionedBy', 'type': '[DatasetPartition]'},
    }

    def __init__(self, linked_service_name, folder_path, description=None, structure=None, parameters=None, file_name=None, format=None, compression=None, partitioned_by=None):
        super(AzureDataLakeStoreDataset, self).__init__(description=description, structure=structure, linked_service_name=linked_service_name, parameters=parameters)
        self.folder_path = folder_path
        self.file_name = file_name
        self.format = format
        self.compression = compression
        self.partitioned_by = partitioned_by
        self.type = 'AzureDataLakeStoreFile'
