/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.osalau;

import ee.ut.soras.wrappers.TextUtilsForMorph;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OsalauSona {
    private MorfAnSona morfSona = null;
    private String normAlgSona = null;
    private List<MARGEND> margendid = null;

    public OsalauSona(MorfAnSona morfSona) {
        this.morfSona = morfSona;
        this.normAlgSona = TextUtilsForMorph.normalizeSpecialSymbols(this.morfSona.getAlgSona());
    }

    public MorfAnSona getMorfSona() {
        return this.morfSona;
    }

    public String getNormAlgSona() {
        return this.normAlgSona;
    }

    public void lisaMargend(MARGEND margend) {
        if (this.margendid == null) {
            this.margendid = new ArrayList<MARGEND>();
        }
        this.margendid.add(margend);
    }

    public void eemaldaMargend(MARGEND margend) {
        if (this.margendid != null) {
            Iterator<MARGEND> iterator = this.margendid.iterator();
            while (iterator.hasNext()) {
                MARGEND olemasolevMargend = iterator.next();
                if (!olemasolevMargend.equals((Object)margend)) continue;
                iterator.remove();
            }
        }
    }

    public void asendaMargend(MARGEND vana, MARGEND uus) {
        this.lisaMargend(uus);
        this.eemaldaMargend(vana);
    }

    public void asendaMargendRange(MARGEND vana, MARGEND uus) {
        if (this.omabMargendit(vana) && !this.omabMargendit(uus)) {
            this.lisaMargend(uus);
            this.eemaldaMargend(vana);
        }
    }

    public boolean omabMargendit(MARGEND margend) {
        return this.margendid != null && this.margendid.contains((Object)margend);
    }

    public List<MARGEND> getKindladOLPMargendid() {
        ArrayList<MARGEND> kindladMargendid = new ArrayList<MARGEND>();
        if (this.margendid != null) {
            for (MARGEND margend : this.margendid) {
                if (margend == MARGEND.KINDEL_PIIR) {
                    kindladMargendid.add(margend);
                    continue;
                }
                if (margend == MARGEND.KIILU_ALGUS) {
                    kindladMargendid.add(margend);
                    continue;
                }
                if (margend != MARGEND.KIILU_LOPP) continue;
                kindladMargendid.add(margend);
            }
        }
        return kindladMargendid;
    }

    public List<MARGEND> getMargendid() {
        return this.margendid;
    }

    public static enum MARGEND {
        KINDEL_PIIR,
        OLETATAV_PIIR,
        KIILU_ALGUS,
        KIILU_LOPP,
        OELDIS,
        KONE_ALGUS,
        KONE_LOPP;

    }
}

