/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus;

import ee.ut.soras.ajavtV2.mudel.ajavaljend.Granulaarsus;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.AjaObjekt;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.AjaPunkt;
import java.util.List;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.base.BaseLocal;

public class SemLeidmiseAbimeetodid {
    public static LocalDateTime applyBaldwinWindow(Granulaarsus field, LocalDateTime currentDateTime, int soughtValue) {
        int addToCurrent;
        if (field == Granulaarsus.DAY_OF_WEEK && 1 <= soughtValue && soughtValue <= 7) {
            int currentDayOfWeek = currentDateTime.getDayOfWeek();
            for (addToCurrent = 0; addToCurrent > -4; --addToCurrent) {
                if (currentDayOfWeek == soughtValue) {
                    return currentDateTime.plusDays(addToCurrent);
                }
                if (--currentDayOfWeek >= 1) continue;
                currentDayOfWeek = 7;
            }
            currentDayOfWeek = currentDateTime.getDayOfWeek();
            for (addToCurrent = 0; addToCurrent < 4; ++addToCurrent) {
                if (currentDayOfWeek == soughtValue) {
                    return currentDateTime.plusDays(addToCurrent);
                }
                if (++currentDayOfWeek <= 7) continue;
                currentDayOfWeek = 1;
            }
        }
        if (field == Granulaarsus.MONTH && 1 <= soughtValue && soughtValue <= 12) {
            int currentMonth = currentDateTime.getMonthOfYear();
            for (addToCurrent = 0; addToCurrent > -6; --addToCurrent) {
                if (currentMonth == soughtValue) {
                    return currentDateTime.plusMonths(addToCurrent);
                }
                if (--currentMonth >= 1) continue;
                currentMonth = 12;
            }
            currentMonth = currentDateTime.getMonthOfYear();
            for (addToCurrent = 0; addToCurrent < 6; ++addToCurrent) {
                if (currentMonth == soughtValue) {
                    return currentDateTime.plusMonths(addToCurrent);
                }
                if (++currentMonth <= 12) continue;
                currentMonth = 1;
            }
            return currentDateTime.withMonthOfYear(soughtValue);
        }
        if (field == Granulaarsus.YEAR_OF_CENTURY && 0 <= soughtValue && soughtValue <= 99) {
            if (soughtValue == 0) {
                soughtValue = 100;
            }
            int currentYear = currentDateTime.getYearOfCentury();
            for (addToCurrent = 0; addToCurrent > -49; --addToCurrent) {
                if (currentYear == soughtValue) {
                    return currentDateTime.plusYears(addToCurrent);
                }
                if (--currentYear >= 1) continue;
                currentYear = 100;
            }
            currentYear = currentDateTime.getYearOfCentury();
            for (addToCurrent = 0; addToCurrent < 49; ++addToCurrent) {
                if (currentYear == soughtValue) {
                    return currentDateTime.plusYears(addToCurrent);
                }
                if (++currentYear <= 100) continue;
                currentYear = 1;
            }
            return currentDateTime.withYearOfCentury(soughtValue);
        }
        return currentDateTime;
    }

    public static LocalDateTime applyBaldwinWindow(Granulaarsus field, LocalDateTime currentDateTime, String soughtValue) {
        if (field == Granulaarsus.MONTH && soughtValue != null && soughtValue.matches("(SP|SU|FA|WI)")) {
            String currentSeason;
            int addToCurrent;
            LocalDate movingFocus = new LocalDate(currentDateTime);
            for (addToCurrent = 0; addToCurrent > -4; --addToCurrent) {
                currentSeason = SemLeidmiseAbimeetodid.getSeason(movingFocus);
                if (currentSeason.equals(soughtValue)) {
                    return currentDateTime.plusMonths(addToCurrent);
                }
                movingFocus = movingFocus.plusMonths(-1);
            }
            movingFocus = new LocalDate(currentDateTime);
            for (addToCurrent = 0; addToCurrent < 4; ++addToCurrent) {
                currentSeason = SemLeidmiseAbimeetodid.getSeason(movingFocus);
                if (currentSeason.equals(soughtValue)) {
                    return currentDateTime.plusMonths(addToCurrent);
                }
                movingFocus = movingFocus.plusMonths(1);
            }
            return SemLeidmiseAbimeetodid.setMiddleOfSeason(currentDateTime, soughtValue);
        }
        if (field == Granulaarsus.MONTH && soughtValue != null && soughtValue.matches("Q(1|2|3|4)")) {
            String currentSeason;
            int addToCurrent;
            LocalDate movingFocus = new LocalDate(currentDateTime);
            for (addToCurrent = 0; addToCurrent > -4; --addToCurrent) {
                currentSeason = SemLeidmiseAbimeetodid.getQuarterOfYear(movingFocus);
                if (currentSeason.equals(soughtValue)) {
                    return currentDateTime.plusMonths(addToCurrent);
                }
                movingFocus = movingFocus.plusMonths(-1);
            }
            movingFocus = new LocalDate(currentDateTime);
            for (addToCurrent = 0; addToCurrent < 4; ++addToCurrent) {
                currentSeason = SemLeidmiseAbimeetodid.getQuarterOfYear(movingFocus);
                if (currentSeason.equals(soughtValue)) {
                    return currentDateTime.plusMonths(addToCurrent);
                }
                movingFocus = movingFocus.plusMonths(1);
            }
            return SemLeidmiseAbimeetodid.setMiddleOfQuarterOfYear(currentDateTime, soughtValue);
        }
        return null;
    }

    public static LocalDateTime findNthSubpartOfGranularity(Granulaarsus superField, Granulaarsus subField, int soughtValueOfSubField, int n, LocalDateTime currentDateTime) {
        if (superField == Granulaarsus.MONTH) {
            LocalDateTime newDate;
            if (subField == Granulaarsus.DAY_OF_WEEK && 1 <= soughtValueOfSubField && soughtValueOfSubField <= 7) {
                int currentMonth;
                if (n > 0) {
                    newDate = currentDateTime.withDayOfMonth(1);
                    while (newDate.getDayOfWeek() != soughtValueOfSubField) {
                        newDate = newDate.plusDays(1);
                    }
                    currentMonth = newDate.getMonthOfYear();
                    if (currentMonth == (newDate = newDate.plusDays((n - 1) * 7)).getMonthOfYear()) {
                        return newDate;
                    }
                } else if (n < 0) {
                    newDate = currentDateTime.withDayOfMonth(currentDateTime.dayOfMonth().getMaximumValue());
                    while (newDate.getDayOfWeek() != soughtValueOfSubField) {
                        newDate = newDate.minusDays(1);
                    }
                    currentMonth = newDate.getMonthOfYear();
                    if (currentMonth == (newDate = newDate.minusDays((n * -1 - 1) * 7)).getMonthOfYear()) {
                        return newDate;
                    }
                }
            }
            if (subField == Granulaarsus.WEEK_OF_YEAR && 1 <= soughtValueOfSubField && soughtValueOfSubField <= 7) {
                if (n > 0) {
                    newDate = currentDateTime.withDayOfMonth(1);
                    while (newDate.getDayOfWeek() != soughtValueOfSubField) {
                        newDate = newDate.plusDays(1);
                    }
                    newDate = newDate.plusDays((n - 1) * 7);
                    return newDate;
                }
                if (n < 0) {
                    newDate = currentDateTime.withDayOfMonth(currentDateTime.dayOfMonth().getMaximumValue());
                    while (newDate.getDayOfWeek() != soughtValueOfSubField) {
                        newDate = newDate.minusDays(1);
                    }
                    newDate = newDate.minusDays((n * -1 - 1) * 7);
                    return newDate;
                }
            }
        }
        return null;
    }

    public static String getQuarterOfYear(LocalDate date) {
        int month = date.getMonthOfYear();
        if (1 <= month && month <= 3) {
            return "Q1";
        }
        if (4 <= month && month <= 6) {
            return "Q2";
        }
        if (7 <= month && month <= 9) {
            return "Q3";
        }
        if (10 <= month && month <= 12) {
            return "Q4";
        }
        return null;
    }

    public static LocalDateTime setMiddleOfQuarterOfYear(LocalDateTime dateTime, String quarter) {
        if (quarter.equals("Q1")) {
            return dateTime.withMonthOfYear(2);
        }
        if (quarter.equals("Q2")) {
            return dateTime.withMonthOfYear(5);
        }
        if (quarter.equals("Q3")) {
            return dateTime.withMonthOfYear(8);
        }
        if (quarter.equals("Q4")) {
            return dateTime.withMonthOfYear(11);
        }
        return dateTime;
    }

    public static String getSeason(LocalDate date) {
        int month = date.getMonthOfYear();
        if (12 <= month || month <= 2) {
            return "WI";
        }
        if (3 <= month && month <= 5) {
            return "SP";
        }
        if (6 <= month && month <= 8) {
            return "SU";
        }
        if (9 <= month && month <= 11) {
            return "FA";
        }
        return null;
    }

    public static LocalDateTime setMiddleOfSeason(LocalDateTime dateTime, String season) {
        if (season.equals("WI")) {
            return dateTime.withMonthOfYear(1);
        }
        if (season.equals("SP")) {
            return dateTime.withMonthOfYear(4);
        }
        if (season.equals("SU")) {
            return dateTime.withMonthOfYear(7);
        }
        if (season.equals("FA")) {
            return dateTime.withMonthOfYear(10);
        }
        return dateTime;
    }

    public static String getPartOfDay(LocalTime time) {
        int hourOfDay = time.getHourOfDay();
        if (0 <= hourOfDay && hourOfDay <= 5) {
            return "NI";
        }
        if (6 <= hourOfDay && hourOfDay <= 11) {
            return "MO";
        }
        if (12 <= hourOfDay && hourOfDay <= 17) {
            return "AF";
        }
        if (18 <= hourOfDay && hourOfDay <= 23) {
            return "EV";
        }
        return null;
    }

    public static String getWordDayOrWeekend(LocalDate date) {
        int weekDay = date.getDayOfWeek();
        if (weekDay == 6 || weekDay == 7) {
            return "WE";
        }
        return "WD";
    }

    public static int getLocalDateTimeFieldExtremum(BaseLocal partial, DateTimeFieldType type, boolean getMax) {
        DateTimeField field = type.getField(partial.getChronology());
        return getMax ? field.getMaximumValue(partial) : field.getMinimumValue(partial);
    }

    public static void closeGranularitiesBelow(List<AjaObjekt> seotudEksplitsiitsedTIMEXid, Granulaarsus minGran, int digits) {
        if (seotudEksplitsiitsedTIMEXid != null) {
            for (AjaObjekt ajaObjekt : seotudEksplitsiitsedTIMEXid) {
                ajaObjekt.closeGranularitiesBelow(minGran, digits);
            }
        }
    }

    public static void jagaOtspunktideVahelPuuduvaidVaartuseid(List<AjaObjekt> seotudEksplitsiitsedTIMEXid) {
        if (seotudEksplitsiitsedTIMEXid != null && seotudEksplitsiitsedTIMEXid.size() == 2) {
            AjaObjekt algusPunkt = seotudEksplitsiitsedTIMEXid.get(0);
            AjaObjekt loppPunkt = seotudEksplitsiitsedTIMEXid.get(1);
            if (algusPunkt instanceof AjaPunkt && loppPunkt instanceof AjaPunkt) {
                if (algusPunkt.getType() == AjaObjekt.TYYP.RECURRENCE) {
                    ((AjaPunkt)loppPunkt).setType(AjaObjekt.TYYP.RECURRENCE);
                } else if (loppPunkt.getType() == AjaObjekt.TYYP.RECURRENCE) {
                    ((AjaPunkt)algusPunkt).setType(AjaObjekt.TYYP.RECURRENCE);
                }
            }
        }
    }
}

