#!/usr/bin/env python

import os

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

from pycanvas import __version__ as version

long_description = 'A client library for accessing the Instructure Canvas rest library. Mostly generated by the swagger-codegen-cli tool.'

packages = [
    'pycanvas',
]

a = os.walk(os.path.join(os.path.dirname(os.path.abspath(__file__)), './pycanvas'))
root, dirs, files = a.next()
for d in dirs:
    packages.append('pycanvas.{}'.format(d))

package_data = {
    '': ['LICENSE', 'README.md'],
}

# with open('README.md') as f:
#     readme = f.read()

setup(
    name='pycanvas',
    version=version,
    description='Client library for Instructure Canvas REST api.',
    long_description=long_description,
    author='Paul Gower',
    author_email='p.gower@gmail.com',
    url='https://github.com/PGower/PyCanvas',
    download_url='https://github.com/PGower/PyCanvas/releases',
    package_dir={'pycanvas': 'pycanvas'},
    packages=packages,
    package_data=package_data,
    license='BSD',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: Web Environment',
        'Programming Language :: Python',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
    keywords=['canvas', 'instructure'],
    install_requires=['urllib3 >= 1.15.1', 'certifi >= 14.05.14', 'six == 1.8.0', 'python_dateutil >= 2.5.3'],
)