DECLARE
   function properties_lateral_string_as_clob (
      db_table_name_list   sys.odcivarchar2list,
      db_object_owner_list sys.odcivarchar2list,
      graph_viz_table_name in varchar2,
      vertex_id_col_name   in varchar2,
      graphname            in varchar2,
      graphowner           in varchar2,
      element_type         in varchar2
   ) return clob is
      m_vcsiz_4k                                        constant pls_integer := 4000;
      lateral_query_string                              clob := '';
      column_names                                      sys.odcivarchar2list;
      object_names                                      sys.odcivarchar2list;
      property_names                                    sys.odcivarchar2list;
      type string_list_type is
         table of varchar2(m_vcsiz_4k) index by pls_integer;
      type varcharlist_table is
         table of string_list_type index by varchar2(m_vcsiz_4k);
      type string_index_by_string is
         table of varchar2(m_vcsiz_4k) index by varchar(m_vcsiz_4k);
      element_table_column_name                         varcharlist_table; --map structure
      element_table_property_name                       varcharlist_table; --map structure
      element_to_key_list_table                         varcharlist_table; --map structure
      selected_col_string                               clob;
      column_expression                                 varchar2(m_vcsiz_4k);
      column_name                                       varchar2(m_vcsiz_4k);
      property_name                                     varchar2(m_vcsiz_4k);
      elementnames                                      sys.odcivarchar2list;
      elementname                                       varchar2(m_vcsiz_4k);
      key_list                                          sys.odcivarchar2list;
      json_condition_string                             clob;
      all_query_string                                  clob := '';
      column_expressions                                sys.odcivarchar2list;
      column_expression_list                            varcharlist_table;
      p1                                                int;
      p2                                                int;
      p3                                                int;
      column_names_for_each_element                     string_list_type;
      property_names_for_each_element                   string_list_type;
      property_names_for_each_element_indexed_by_string string_index_by_string;
      column_expressions_for_each_element               string_list_type;
      key_list_for_each_element                         string_list_type;
      object_to_elements                                varcharlist_table; --map structure
      elements_for_each_object                          string_list_type;
      labels                                            sys.odcivarchar2list;
      labels_for_each_element                           string_list_type;
      element_to_labels                                 varcharlist_table;
      labels_string                                     clob;
      edge_keys                                         sys.odcivarchar2list;
      vertex_tab_names                                  sys.odcivarchar2list;
      vertex_element_names                              sys.odcivarchar2list;
      vertex_keys                                       sys.odcivarchar2list;
      vertex_object_names                               sys.odcivarchar2list;
      vertex_object_owners                              sys.odcivarchar2list;
      edge_tab_names                                    sys.odcivarchar2list;
      src_vertex_tab_name_table                         string_index_by_string;
      src_vertex_object_name_table                      string_index_by_string;
      src_vertex_object_owner_table                     string_index_by_string;
      dest_vertex_tab_name_table                        string_index_by_string;
      dest_vertex_object_name_table                     string_index_by_string;
      dest_vertex_object_owner_table                    string_index_by_string;
      edge_col_name                                     sys.odcivarchar2list;
      vertex_col_name                                   sys.odcivarchar2list;
      edge_end_list                                     sys.odcivarchar2list;
      edge_element_names                                sys.odcivarchar2list;
      src_edge_col_name_table                           varcharlist_table;
      src_vertex_col_name_table                         varcharlist_table;
      dest_edge_col_name_table                          varcharlist_table;
      dest_vertex_col_name_table                        varcharlist_table;
      edge_to_keys_table                                varcharlist_table;
      vertex_keys_table                                 varcharlist_table;
      src_json_string                                   clob;
      dest_json_string                                  clob;
      src_edge_col_name_for_each_edge                   string_list_type;
      src_vertex_col_name_for_each_edge                 string_list_type;
      dest_edge_col_name_for_each_edge                  string_list_type;
      dest_vertex_col_name_for_each_edge                string_list_type;
      edge_keys_for_each_edge                           string_list_type;
      vertex_keys_for_each_vertex                       string_list_type;
      element_name                                      varchar2(m_vcsiz_4k);
   begin
      if element_type = 'EDGE' then
         select distinct vertex_tab_name,
                         object_name,
                         edge_tab_name,
                         edge_end,
                         elements.object_owner
         bulk collect
           into
            vertex_tab_names,
            vertex_object_names,
            edge_tab_names,
            edge_end_list,
            vertex_object_owners
           from sys.all_pg_edge_relationships relationships
          inner join sys.all_pg_elements elements
         on ( relationships.vertex_tab_name = elements.element_name
            and relationships.graph_name = elements.graph_name
            and relationships.owner = elements.owner )
          where relationships.graph_name = graphname
            and elements.owner = graphowner;

         for idx1 in 1..edge_tab_names.count loop
            if edge_end_list(idx1) = 'SOURCE' then
               src_vertex_tab_name_table(edge_tab_names(idx1)) := vertex_tab_names(idx1);
               src_vertex_object_name_table(edge_tab_names(idx1)) := vertex_object_names(idx1);
               src_vertex_object_owner_table(edge_tab_names(idx1)) := vertex_object_owners(idx1);
            else
               dest_vertex_tab_name_table(edge_tab_names(idx1)) := vertex_tab_names(idx1);
               dest_vertex_object_name_table(edge_tab_names(idx1)) := vertex_object_names(idx1);
               dest_vertex_object_owner_table(edge_tab_names(idx1)) := vertex_object_owners(idx1);
            end if;
         end loop;

         select distinct edge_col_name,
                         vertex_col_name,
                         edge_tab_name
         bulk collect
           into
            edge_col_name,
            vertex_col_name,
            edge_tab_names
           from sys.all_pg_edge_relationships relationships
          inner join sys.all_pg_elements elements
         on ( relationships.vertex_tab_name = elements.element_name
            and relationships.graph_name = elements.graph_name
            and relationships.owner = elements.owner )
          where relationships.graph_name = graphname
            and elements.owner = graphowner
            and edge_end = 'SOURCE'
          order by edge_tab_name;

         for idx1 in 1..edge_tab_names.count loop
            if idx1 = 1 then
               p1 := 1;
               src_edge_col_name_for_each_edge := new string_list_type();
               src_edge_col_name_for_each_edge(p1) := edge_col_name(idx1);
               src_vertex_col_name_for_each_edge := new string_list_type();
               src_vertex_col_name_for_each_edge(p1) := vertex_col_name(idx1);
               p1 := p1 + 1;
            else
               if edge_tab_names(idx1) = edge_tab_names(idx1 - 1) then
                  src_edge_col_name_for_each_edge(p1) := edge_col_name(idx1);
                  src_vertex_col_name_for_each_edge(p1) := vertex_col_name(idx1);
                  p1 := p1 + 1;
               else
                  src_edge_col_name_table(edge_tab_names(idx1 - 1)) := src_edge_col_name_for_each_edge;
                  src_vertex_col_name_table(edge_tab_names(idx1 - 1)) := src_vertex_col_name_for_each_edge;
                  p1 := 1;
                  src_edge_col_name_for_each_edge := new string_list_type();
                  src_edge_col_name_for_each_edge(p1) := edge_col_name(idx1);
                  src_vertex_col_name_for_each_edge := new string_list_type();
                  src_vertex_col_name_for_each_edge(p1) := vertex_col_name(idx1);
                  p1 := p1 + 1;
               end if;
            end if;

            if idx1 = edge_tab_names.count then
               src_edge_col_name_table(edge_tab_names(idx1)) := src_edge_col_name_for_each_edge;
               src_vertex_col_name_table(edge_tab_names(idx1)) := src_vertex_col_name_for_each_edge;
            end if;
         end loop;

         select distinct edge_col_name,
                         vertex_col_name,
                         edge_tab_name
         bulk collect
           into
            edge_col_name,
            vertex_col_name,
            edge_tab_names
           from sys.all_pg_edge_relationships relationships
          inner join sys.all_pg_elements elements
         on ( relationships.vertex_tab_name = elements.element_name
            and relationships.graph_name = elements.graph_name
            and relationships.owner = elements.owner )
          where relationships.graph_name = graphname
            and elements.owner = graphowner
            and edge_end = 'DESTINATION'
          order by edge_tab_name;

         for idx1 in 1..edge_tab_names.count loop
            if idx1 = 1 then
               p1 := 1;
               dest_edge_col_name_for_each_edge := new string_list_type();
               dest_edge_col_name_for_each_edge(p1) := edge_col_name(idx1);
               dest_vertex_col_name_for_each_edge := new string_list_type();
               dest_vertex_col_name_for_each_edge(p1) := vertex_col_name(idx1);
               p1 := p1 + 1;
            else
               if edge_tab_names(idx1) = edge_tab_names(idx1 - 1) then
                  dest_edge_col_name_for_each_edge(p1) := edge_col_name(idx1);
                  dest_vertex_col_name_for_each_edge(p1) := vertex_col_name(idx1);
                  p1 := p1 + 1;
               else
                  dest_edge_col_name_table(edge_tab_names(idx1 - 1)) := dest_edge_col_name_for_each_edge;
                  dest_vertex_col_name_table(edge_tab_names(idx1 - 1)) := dest_vertex_col_name_for_each_edge;
                  p1 := 1;
                  dest_edge_col_name_for_each_edge := new string_list_type();
                  dest_edge_col_name_for_each_edge(p1) := edge_col_name(idx1);
                  dest_vertex_col_name_for_each_edge := new string_list_type();
                  dest_vertex_col_name_for_each_edge(p1) := vertex_col_name(idx1);
                  p1 := p1 + 1;
               end if;
            end if;

            if idx1 = edge_tab_names.count then
               dest_edge_col_name_table(edge_tab_names(idx1)) := dest_edge_col_name_for_each_edge;
               dest_vertex_col_name_table(edge_tab_names(idx1)) := dest_vertex_col_name_for_each_edge;
            end if;
         end loop;

         select keys.element_name,
                keys.column_name
         bulk collect
           into
            vertex_element_names,
            vertex_keys
           from sys.all_pg_keys keys
          inner join sys.all_pg_elements elements
         on ( elements.element_name = keys.element_name
            and keys.owner = elements.owner
            and keys.graph_name = elements.graph_name )
          inner join sys.all_tab_columns columns
         on ( columns.owner = elements.object_owner
            and columns.table_name = elements.object_name
            and columns.column_name = keys.column_name )
          where keys.graph_name = graphname
            and keys.owner = graphowner
            and elements.element_kind = 'VERTEX'
          order by keys.element_name,
                   columns.column_id;

         for idx1 in 1..vertex_element_names.count loop
            if idx1 = 1 then
               p1 := 1;
               vertex_keys_for_each_vertex := new string_list_type();
               vertex_keys_for_each_vertex(p1) := vertex_keys(idx1);
               p1 := p1 + 1;
            else
               if vertex_element_names(idx1) = vertex_element_names(idx1 - 1) then
                  vertex_keys_for_each_vertex(p1) := vertex_keys(idx1);
                  p1 := p1 + 1;
               else
                  vertex_keys_table(vertex_element_names(idx1 - 1)) := vertex_keys_for_each_vertex;
                  p1 := 1;
                  vertex_keys_for_each_vertex := new string_list_type();
                  vertex_keys_for_each_vertex(p1) := vertex_keys(idx1);
                  p1 := p1 + 1;
               end if;
            end if;

            if idx1 = vertex_element_names.count then
               vertex_keys_table(vertex_element_names(idx1)) := vertex_keys_for_each_vertex;
            end if;
         end loop;

         select keys.column_name,
                keys.element_name
         bulk collect
           into
            edge_keys,
            edge_element_names
           from sys.all_pg_keys keys
          inner join sys.all_pg_elements elements
         on ( elements.element_name = keys.element_name
            and keys.graph_name = elements.graph_name
            and keys.owner = elements.owner )
          inner join sys.all_tab_columns columns
         on ( columns.owner = elements.object_owner
            and columns.table_name = elements.object_name
            and columns.column_name = keys.column_name )
          where element_kind = 'EDGE'
            and keys.graph_name = graphname
            and elements.owner = graphowner
          order by object_name;

         for idx1 in 1..edge_element_names.count loop
            if idx1 = 1 then
               p1 := 1;
               edge_keys_for_each_edge := new string_list_type();
               edge_keys_for_each_edge(p1) := edge_keys(idx1);
               p1 := p1 + 1;
            else
               if edge_element_names(idx1) = edge_element_names(idx1 - 1) then
                  edge_keys_for_each_edge(p1) := edge_keys(idx1);
                  p1 := p1 + 1;
               else
                  edge_to_keys_table(edge_element_names(idx1 - 1)) := edge_keys_for_each_edge;
                  p1 := 1;
                  edge_keys_for_each_edge := new string_list_type();
                  edge_keys_for_each_edge(p1) := edge_keys(idx1);
                  p1 := p1 + 1;
               end if;
            end if;

            if idx1 = edge_element_names.count then
               edge_to_keys_table(edge_element_names(idx1)) := edge_keys_for_each_edge;
            end if;
         end loop;
      end if;

      select object_name,
             elements.element_name,
             elem_labels.label_name,
             label_properties.property_name,
             column_name,
             prop_definitions.column_expr
      bulk collect
        into
         object_names,
         elementnames,
         labels,
         property_names,
         column_names,
         column_expressions
        from sys.all_pg_elements elements
        left join sys.all_pg_element_labels elem_labels
      on ( elements.element_name = elem_labels.element_name
         and elements.owner = elem_labels.owner
         and elements.graph_name = elem_labels.graph_name )
        left join sys.all_pg_label_properties label_properties
      on ( elem_labels.label_name = label_properties.label_name
         and elem_labels.owner = label_properties.owner
         and elem_labels.graph_name = label_properties.graph_name )
        left join sys.all_pg_prop_definitions prop_definitions
      on ( prop_definitions.property_name = label_properties.property_name
         and prop_definitions.element_name = elements.element_name
         and prop_definitions.owner = elements.owner
         and elements.graph_name = prop_definitions.graph_name )
       where elements.element_kind = element_type
         and elements.graph_name = graphname
         and elements.owner = graphowner
       order by object_name,
                elements.element_name,
                elem_labels.label_name,
                label_properties.property_name;

      for idx1 in 1..object_names.count loop
         if idx1 = 1
         or object_names(idx1) != object_names(idx1 - 1) then
            if idx1 != 1 then
               object_to_elements(object_names(idx1 - 1)) := elements_for_each_object;
               element_table_column_name(elementnames(idx1 - 1)) := column_names_for_each_element;
               element_table_property_name(elementnames(idx1 - 1)) := property_names_for_each_element;
               column_expression_list(elementnames(idx1 - 1)) := column_expressions_for_each_element;
               element_to_labels(elementnames(idx1 - 1)) := labels_for_each_element;
            end if;

            column_names_for_each_element := new string_list_type();
            property_names_for_each_element := new string_list_type();
            property_names_for_each_element_indexed_by_string.delete;
            labels_for_each_element := new string_list_type();
            elements_for_each_object := new string_list_type();
            column_expressions_for_each_element := new string_list_type();
            p1 := 1;
            p2 := 1;
            p3 := 1;
            column_names_for_each_element(p1) := column_names(idx1);
            if
               property_names(idx1) is not null
               and not property_names_for_each_element_indexed_by_string.exists(property_names(idx1))
            then
               property_names_for_each_element(p1) := property_names(idx1);
               property_names_for_each_element_indexed_by_string(property_names(idx1)) := property_names(idx1);
               column_names_for_each_element(p1) := column_names(idx1);
               column_expressions_for_each_element(p1) := column_expressions(idx1);
            end if;

            elements_for_each_object(p2) := elementnames(idx1);
            labels_for_each_element(p3) := labels(idx1);
            p1 := p1 + 1;
            p2 := p2 + 1;
            p3 := p3 + 1;
         elsif elementnames(idx1) = elementnames(idx1 - 1) then
            if
               property_names(idx1) is not null
               and property_names(idx1) != property_names(idx1 - 1)
               and not property_names_for_each_element_indexed_by_string.exists(property_names(idx1))
            then
               column_names_for_each_element(p1) := column_names(idx1);
               property_names_for_each_element(p1) := property_names(idx1);
               property_names_for_each_element_indexed_by_string(property_names(idx1)) := property_names(idx1);
               column_expressions_for_each_element(p1) := column_expressions(idx1);
               p1 := p1 + 1;
            end if;
            if labels(idx1) != labels_for_each_element(p3 - 1) then
               labels_for_each_element(p3) := labels(idx1);
               p3 := p3 + 1;
            end if;
         else
            elements_for_each_object(p2) := elementnames(idx1);
            p2 := p2 + 1;
            element_table_column_name(elementnames(idx1 - 1)) := column_names_for_each_element;
            element_table_property_name(elementnames(idx1 - 1)) := property_names_for_each_element;
            column_expression_list(elementnames(idx1 - 1)) := column_expressions_for_each_element;
            element_to_labels(elementnames(idx1 - 1)) := labels_for_each_element;
            column_names_for_each_element := new string_list_type();
            property_names_for_each_element := new string_list_type();
            property_names_for_each_element_indexed_by_string.delete;
            column_expressions_for_each_element := new string_list_type();
            labels_for_each_element := new string_list_type();
            p1 := 1;
            p3 := 1;
            if
               property_names(idx1) is not null
               and not property_names_for_each_element_indexed_by_string.exists(property_names(idx1))
            then
               column_names_for_each_element(p1) := column_names(idx1);
               property_names_for_each_element(p1) := property_names(idx1);
               property_names_for_each_element_indexed_by_string(property_names(idx1)) := property_names(idx1);
               column_expressions_for_each_element(p1) := column_expressions(idx1);
            end if;
            labels_for_each_element(p3) := labels(idx1);
            p1 := p1 + 1;
            p3 := p3 + 1;
         end if;

         if idx1 = object_names.count then
            object_to_elements(object_names(idx1)) := elements_for_each_object;
            element_table_column_name(elementnames(idx1)) := column_names_for_each_element;
            element_table_property_name(elementnames(idx1)) := property_names_for_each_element;
            column_expression_list(elementnames(idx1)) := column_expressions_for_each_element;
            element_to_labels(elementnames(idx1)) := labels_for_each_element;
         end if;
      end loop;

      select elements.element_name,
             keys.column_name
      bulk collect
        into
         elementnames,
         key_list
        from sys.all_pg_keys keys
       inner join sys.all_pg_elements elements
      on ( elements.element_name = keys.element_name
         and keys.graph_name = elements.graph_name
         and keys.owner = elements.owner )
       where element_kind = element_type
         and keys.graph_name = graphname
         and elements.owner = graphowner
       order by elements.element_name,
                keys.column_name;

      for idx1 in 1..elementnames.count loop
         if idx1 = 1 then
            key_list_for_each_element := new string_list_type();
            p1 := 1;
            key_list_for_each_element(p1) := key_list(idx1);
            p1 := p1 + 1;
         else
            if elementnames(idx1) = elementnames(idx1 - 1) then
               key_list_for_each_element(p1) := key_list(idx1);
               p1 := p1 + 1;
            else
               element_to_key_list_table(elementnames(idx1 - 1)) := key_list_for_each_element;
               key_list_for_each_element := new string_list_type();
               p1 := 1;
               key_list_for_each_element(p1) := key_list(idx1);
               p1 := p1 + 1;
            end if;
         end if;

         if idx1 = elementnames.count then
            element_to_key_list_table(elementnames(idx1)) := key_list_for_each_element;
         end if;
      end loop;

      for idx1 in 1..db_table_name_list.count loop
         for idx6 in 1..object_to_elements(db_table_name_list(idx1)).count loop
            element_name := object_to_elements(db_table_name_list(idx1))(idx6);
            lateral_query_string := 'SELECT JSON_OBJECT(';
            selected_col_string := '';
            for idx2 in 1..db_table_name_list.count loop
               if idx1 = idx2 then
                  for idx4 in 1..element_table_property_name(element_name).count loop
                     column_name := element_table_column_name(element_name)(idx4);
                     column_expression := column_expression_list(element_name)(idx4);
                     if column_expression is null then
                        selected_col_string := selected_col_string
                                               || 'q''['
                                               || element_table_property_name(element_name)(idx4)
                                               || ']'''
                                               || ' VALUE '
                                               || 'x."'
                                               || column_name
                                               || '"';
                        if ( idx4 = element_table_property_name(element_name).count ) then
                           selected_col_string := selected_col_string || ' ';
                        else
                           selected_col_string := selected_col_string || ', ';
                        end if;
                     else
                        selected_col_string := selected_col_string
                                               || 'q''['
                                               || element_table_property_name(element_name)(idx4)
                                               || ']'''
                                               || ' VALUE '
                                               || column_expression
                                               || '';
                        if ( idx4 != element_table_property_name(element_name).count ) then
                           selected_col_string := selected_col_string || ', ';
                        end if;
                     end if;
                  end loop;
               end if;
            end loop;

            selected_col_string := selected_col_string || ' NULL ON NULL RETURNING JSON) AS properties ';
            labels_string := '';
            for idx4 in 1..element_to_labels(element_name).count loop
               labels_string := labels_string
                                || 'q''['
                                || element_to_labels(element_name)(idx4)
                                || ']''';
               if ( idx4 != element_to_labels(element_name).count ) then
                  labels_string := labels_string || ', ';
               end if;
            end loop;

            selected_col_string := selected_col_string
                                   || ', JSON_ARRAY('
                                   || labels_string
                                   || ' returning JSON) AS labels';
            if element_type = 'EDGE' then
               selected_col_string := selected_col_string
                                      || ', q''['
                                      || src_vertex_tab_name_table(element_name)
                                      || ']'' || json_object(';
               src_json_string := '';
               dest_json_string := '';
               for idx2 in 1..vertex_keys_table(src_vertex_tab_name_table(element_name)).count loop
                  src_json_string := src_json_string
                                     || 'q''['
                                     || vertex_keys_table(src_vertex_tab_name_table(element_name))(idx2)
                                     || ']'' value src_table."'
                                     || vertex_keys_table(src_vertex_tab_name_table(element_name))(idx2)
                                     || '"';
                  if ( idx2 = vertex_keys_table(src_vertex_tab_name_table(element_name)).count ) then
                     src_json_string := src_json_string || ' ';
                  else
                     src_json_string := src_json_string || ', ';
                  end if;
               end loop;

               selected_col_string := selected_col_string || src_json_string;
               selected_col_string := selected_col_string
                                      || ') as source, q''['
                                      || dest_vertex_tab_name_table(element_name)
                                      || ']'' || json_object(';
               for idx3 in 1..vertex_keys_table(dest_vertex_tab_name_table(element_name)).count loop
                  dest_json_string := dest_json_string
                                      || 'q''['
                                      || vertex_keys_table(dest_vertex_tab_name_table(element_name))(idx3)
                                      || ']'' value dst_table."'
                                      || vertex_keys_table(dest_vertex_tab_name_table(element_name))(idx3)
                                      || '"';
                  if ( idx3 = vertex_keys_table(dest_vertex_tab_name_table(element_name)).count ) then
                     dest_json_string := dest_json_string || ' ';
                  else
                     dest_json_string := dest_json_string || ', ';
                  end if;
               end loop;

               selected_col_string := selected_col_string || dest_json_string;
               selected_col_string := selected_col_string || ') as target ';
            end if;

            lateral_query_string := lateral_query_string
                                    || selected_col_string
                                    || ' FROM "'
                                    || db_object_owner_list(idx1)
                                    || '"."'
                                    || db_table_name_list(idx1)
                                    || '" X ';

            if element_type = 'EDGE' then
               lateral_query_string := lateral_query_string
                                       || ' JOIN "'
                                       || src_vertex_object_owner_table(element_name)
                                       || '"."'
                                       || src_vertex_object_name_table(element_name)
                                       || '" src_table ON (';
               src_json_string := '';
               for idx4 in 1..src_edge_col_name_table(element_name).count loop
                  src_json_string := src_json_string
                                     || 'x."'
                                     || src_edge_col_name_table(element_name)(idx4)
                                     || '" = src_table."'
                                     || src_vertex_col_name_table(element_name)(idx4)
                                     || '"';
                  if idx4 = src_edge_col_name_table(element_name).count then
                     src_json_string := src_json_string || ' ';
                  else
                     src_json_string := src_json_string || ' AND ';
                  end if;
               end loop;

               lateral_query_string := lateral_query_string
                                       || src_json_string
                                       || ')';
               lateral_query_string := lateral_query_string
                                       || ' JOIN "'
                                       || dest_vertex_object_owner_table(element_name)
                                       || '"."'
                                       || dest_vertex_object_name_table(element_name)
                                       || '" dst_table ON (';

               dest_json_string := '';
               for idx4 in 1..dest_edge_col_name_table(element_name).count loop
                  dest_json_string := dest_json_string
                                      || 'x."'
                                      || dest_edge_col_name_table(element_name)(idx4)
                                      || '" = dst_table."'
                                      || dest_vertex_col_name_table(element_name)(idx4)
                                      || '"';
                  if ( idx4 = dest_edge_col_name_table(element_name).count ) then
                     dest_json_string := dest_json_string || ' ';
                  else
                     dest_json_string := dest_json_string || ' AND ';
                  end if;
               end loop;

               lateral_query_string := lateral_query_string
                                       || dest_json_string
                                       || ')';
            end if;

            json_condition_string := '';
            for idx5 in 1..element_to_key_list_table(element_name).count loop
               json_condition_string := json_condition_string
                                        || 'X."'
                                        || element_to_key_list_table(element_name)(idx5)
                                        || '"= JSON_QUERY('
                                        || graph_viz_table_name
                                        || '.'
                                        || vertex_id_col_name
                                        || ', ''$.KEY_VALUE."'
                                        || replace(
                  replace(
                     element_to_key_list_table(element_name)(idx5),
                     '''',
                     ''''''
                  ),
                  '\',
                  '\\'
               )
                                        || '"'' RETURNING JSON)';
               if ( idx5 = element_to_key_list_table(element_name).count ) then
                  json_condition_string := json_condition_string || '';
               else
                  json_condition_string := json_condition_string || ' AND ';
               end if;
            end loop;

            lateral_query_string := lateral_query_string
                                    || 'WHERE JSON_VALUE("'
                                    || graph_viz_table_name
                                    || '"."'
                                    || vertex_id_col_name
                                    || '", ''$.ELEM_TABLE'') = q''['
                                    || element_name
                                    || ']'' AND '
                                    || json_condition_string;
            all_query_string := all_query_string
                                || lateral_query_string
                                || ' ';
            if (
               idx1 = db_table_name_list.count
               and idx6 = object_to_elements(db_table_name_list(idx1)).count
            ) then
               all_query_string := all_query_string || ' ';
            else
               all_query_string := all_query_string || 'UNION ALL ';
            end if;
         end loop;
      end loop;

      return all_query_string;
   end properties_lateral_string_as_clob;
   function build_json_using_json_array (
      vertex_table json_array_t,
      edge_table   json_array_t,
      counter      number,
      graphname    varchar2,
      graphowner   varchar2
   ) return clob is
      vertex_underlying_db_name_list sys.odcivarchar2list;
      vertex_db_table_object_owner   sys.odcivarchar2list;
      edge_underlying_db_name_list   sys.odcivarchar2list;
      edge_db_table_object_owner     sys.odcivarchar2list;
      query_string                   clob;
      lateralstring                  clob;
      sub_query_string               clob;
      vertex                         json;
      edge                           json;
      json_file                      clob;
      distinct_vertex_table          json;
      distinct_edge_table            json;
      temp_json                      json;
   begin
      select distinct elements.object_name,
                      elements.object_owner
      bulk collect
        into
         vertex_underlying_db_name_list,
         vertex_db_table_object_owner
        from sys.all_pg_elements elements
        left join sys.all_pg_element_labels elem_labels
      on ( elements.element_name = elem_labels.element_name
         and elements.owner = elem_labels.owner
         and elements.graph_name = elem_labels.graph_name )
        left join sys.all_pg_label_properties label_properties
      on ( elem_labels.label_name = label_properties.label_name
         and elem_labels.owner = label_properties.owner
         and elem_labels.graph_name = label_properties.graph_name )
        left join sys.all_pg_prop_definitions prop_definitions
      on ( prop_definitions.property_name = label_properties.property_name
         and prop_definitions.element_name = elements.element_name
         and prop_definitions.owner = elements.owner
         and elements.graph_name = prop_definitions.graph_name )
       where elements.element_kind = 'VERTEX'
         and elements.graph_name = graphname
         and elements.owner = graphowner;

      if ( vertex_table.get_size != 0 ) then
         temp_json := vertex_table.to_json();
         select json_arrayagg(v_id returning json)
           into distinct_vertex_table
           from (
            select distinct v_id
              from
               json_table ( temp_json,'$[*]'
                  columns (
                     v_id json path '$'
                  )
               )
         );

         query_string := 'WITH VERTICES AS (';
         lateralstring := properties_lateral_string_as_clob(
            vertex_underlying_db_name_list,
            vertex_db_table_object_owner,
            'VT',
            'V_ID',
            graphname,
            graphowner,
            'VERTEX'
         );
         sub_query_string := '
          SELECT
            JSON_OBJECT (''id'' VALUE JSON_VALUE(VT.V_ID,
            ''$.ELEM_TABLE'') || JSON_QUERY(VT.V_ID,
            ''$.KEY_VALUE''),
            ''properties'' VALUE PROPERTIES_TABLE.PROPERTIES,
            ''labels'' VALUE PROPERTIES_TABLE.LABELS ABSENT ON NULL RETURNING JSON) AS VERTEX
          FROM
            JSON_TABLE(:1  , ''$[*]'' COLUMNS(V_ID json path ''$'')) AS VT,
            LATERAL('
                             || lateralstring
                             || ') PROPERTIES_TABLE ';
         query_string := query_string || sub_query_string;
         query_string := query_string || '
        )
        SELECT
          JSON_ARRAYAGG(VERTEX RETURNING JSON)
        FROM
          VERTICES';
         execute immediate query_string
           into vertex
            using distinct_vertex_table;
      else
         select json_array()
           into vertex;
      end if;

      select distinct elements.object_name,
                      elements.object_owner
      bulk collect
        into
         edge_underlying_db_name_list,
         edge_db_table_object_owner
        from sys.all_pg_elements elements
       inner join sys.all_pg_element_labels elements_labels
      on ( elements.element_name = elements_labels.element_name
         and elements.graph_name = elements_labels.graph_name
         and elements.owner = elements_labels.owner )
       where elements.element_kind = 'EDGE'
         and elements.graph_name = graphname
         and elements.owner = graphowner;

      if ( edge_table.get_size != 0 ) then
         temp_json := edge_table.to_json();
         select json_arrayagg(e_id returning json)
           into distinct_edge_table
           from (
            select distinct e_id
              from
               json_table ( temp_json,'$[*]'
                  columns (
                     e_id json path '$'
                  )
               )
         );
         query_string := 'WITH EDGES AS (
            SELECT
              JSON_OBJECT(''id'' VALUE JSON_VALUE(ET.E_ID,
              ''$.ELEM_TABLE'') || JSON_QUERY(ET.E_ID,
              ''$.KEY_VALUE''),
              ''source'' value PROPERTIES_TABLE.SOURCE,
              ''target'' value PROPERTIES_TABLE.TARGET,
              ''properties'' VALUE PROPERTIES_TABLE.PROPERTIES,
              ''labels'' VALUE PROPERTIES_TABLE.LABELS ABSENT ON NULL RETURNING JSON ) AS EDGE
            FROM
              JSON_TABLE(:1  , ''$[*]'' COLUMNS(E_ID json path ''$'')) AS ET,
              LATERAL(';
         lateralstring := properties_lateral_string_as_clob(
            edge_underlying_db_name_list,
            edge_db_table_object_owner,
            'ET',
            'E_ID',
            graphname,
            graphowner,
            'EDGE'
         );
         query_string := query_string || lateralstring;
         query_string := query_string || ') PROPERTIES_TABLE) SELECT JSON_ARRAYAGG(EDGE RETURNING JSON) FROM EDGES';
         execute immediate query_string
           into edge
            using distinct_edge_table;
      else
         select json_array()
           into edge;
      end if;

      select
         json_object(
            'vertices' value vertex,
                     'edges' value edge,
                     'numResults' value counter,
                     'graphOwner' value graphowner,
                     'graphName' value graphname
         returning clob)
        into json_file
        from sys.dual;
      return json_file;
   end build_json_using_json_array;
   function ora_graph_build_json_using_json_array (
      vertex_table json_array_t,
      edge_table   json_array_t,
      counter      number,
      graphname    varchar2,
      graphowner   varchar2
   ) return clob is
   begin
      return build_json_using_json_array(
         vertex_table,
         edge_table,
         counter,
         graphname,
         graphowner
      );
   end ora_graph_build_json_using_json_array;
   function ora_sqlgraph_to_json (
      curs_id    integer,
      page_start number default 0,
      page_size  number default null
   ) return clob is
      m_vcsiz_4k                constant pls_integer := 4000;
      json_file                 clob; --the returned result
      graphname                 varchar2(m_vcsiz_4k);
      element_name              varchar2(m_vcsiz_4k);
      graphowner                varchar2(m_vcsiz_4k);
      -- Define a type for caching element information
      TYPE ELEMENT_REC IS RECORD (
         ELEMENT_NAME VARCHAR2(M_VCSIZ_4K),
         ELEMENT_KIND VARCHAR2(M_VCSIZ_4K)
      );
      TYPE ELEMENT_TAB IS TABLE OF ELEMENT_REC;
      ELEMENT_CACHE                           ELEMENT_TAB := ELEMENT_TAB();
      l_cols                    integer;
      tab_rec                   sys.dbms_sql.desc_tab;
      cur                       sys_refcursor;
      l_flag                    number;
      l_json                    json;
      vertex_id_column_list     sys.odcinumberlist := sys.odcinumberlist();
      edge_id_column_list       sys.odcinumberlist := sys.odcinumberlist();
      p1                        number := 0; -- rows rendered
      v1                        number := 1;
      e1                        number := 1;
      vertex_table              json_array_t := json_array_t();
      edge_table                json_array_t := json_array_t();
      l_having_element_id       boolean := false;
      counter                   number := 0; -- rows fetched
      l_json_obj                json_object_t;
      islastresultset           boolean := false;
      fetch_rows_integer        integer;
      multi_graph_error_message constant varchar2(m_vcsiz_4k) := 'ora_sqlgraph_to_json only supports queries from a single graph. Please adjust the query accordingly.'
      ;
   begin
      sys.dbms_sql.describe_columns(
         c       => curs_id,
         col_cnt => l_cols,
         desc_t  => tab_rec
      );

      for pos in 1..l_cols loop
         case tab_rec(pos).col_type
            when 119 then
               sys.dbms_sql.define_column(
                  curs_id,
                  pos,
                  l_json
               );
            else
               null;
         end case;
      end loop;

      loop
         fetch_rows_integer := sys.dbms_sql.fetch_rows(curs_id);
         if fetch_rows_integer > 0 then
            counter := counter + 1;
            if ( page_start < 0
            or page_size <= 0 ) then
               raise_application_error(
                  -20000,
                  'Please provide valid values for page_start and page_size parameter. page_start should be an integer equal to or greater than 0. page_size should be an integer greater than 0.'
               );
            end if;

            if ( (
               counter > page_start
               and counter <= page_start + page_size
            )
            or ( page_size is null ) ) then
               if p1 = 0 then
                  for pos in 1..l_cols loop
                     if tab_rec(pos).col_type = 119 then
                        sys.dbms_sql.column_value(
                           curs_id,
                           pos,
                           l_json
                        );
                        if
                           json_exists(
                              l_json,
                              '$.ELEM_TABLE'
                           )
                           and json_exists(
                              l_json,
                              '$.GRAPH_OWNER'
                           )
                           and json_exists(
                              l_json,
                              '$.GRAPH_NAME'
                           )
                           and json_exists(
                              l_json,
                              '$.KEY_VALUE'
                           )
                        then
                           l_having_element_id := true;
                           if
                              graphname is null
                              and graphowner is null
                           then
                              graphname := json_value(l_json,
           '$.GRAPH_NAME');
                              graphowner := json_value(l_json,
           '$.GRAPH_OWNER');

                           -- Populate the cache with all elements for this graph and owner
                           SELECT
                           ELEMENT_NAME,
                           ELEMENT_KIND
                           BULK COLLECT INTO ELEMENT_CACHE
                           FROM
                           SYS.ALL_PG_ELEMENTS
                           WHERE
                           GRAPH_NAME = GRAPHNAME
                           AND OWNER = GRAPHOWNER;

                           else
                              if graphname != json_value(l_json,
           '$.GRAPH_NAME')
                              or graphowner != json_value(l_json,
           '$.GRAPH_OWNER') then
                                 raise_application_error(
                                    -20000,
                                    multi_graph_error_message
                                 );
                              end if;
                           end if;

                           -- Check if the element is in our stored list
                           ELEMENT_NAME := NULL;
                           FOR i IN 1 .. ELEMENT_CACHE.COUNT LOOP
                              IF ELEMENT_CACHE(i).ELEMENT_NAME = JSON_VALUE(L_JSON, '$.ELEM_TABLE') THEN
                              ELEMENT_NAME := ELEMENT_CACHE(i).ELEMENT_KIND;
                              EXIT;
                              END IF;
                           END LOOP;

                           IF ELEMENT_NAME IS NULL THEN
                              -- If not found in cache, raise an error or handle accordingly
                              RAISE_APPLICATION_ERROR(-20000, 'Element ' || JSON_VALUE(L_JSON, '$.ELEM_TABLE') || ' not found in graph ' || GRAPHNAME);
                           END IF;

                           if element_name = 'VERTEX' then
                              vertex_id_column_list.extend;
                              vertex_id_column_list(v1) := pos;
                              v1 := v1 + 1;
                              vertex_table.append(l_json);
                           else
                              edge_id_column_list.extend;
                              edge_id_column_list(e1) := pos;
                              e1 := e1 + 1;
                              edge_table.append(l_json);
                           end if;
                        end if;
                     end if;
                  end loop;
               else
                  if graphname != json_value(l_json,
           '$.GRAPH_NAME')
                  or graphowner != json_value(l_json,
           '$.GRAPH_OWNER') then
                     raise_application_error(
                        -20000,
                        multi_graph_error_message
                     );
                  end if;

                  for i in 1..vertex_id_column_list.count loop
                     sys.dbms_sql.column_value(
                        curs_id,
                        vertex_id_column_list(i),
                        l_json
                     );
                     vertex_table.append(l_json);
                  end loop;

                  for i in 1..edge_id_column_list.count loop
                     sys.dbms_sql.column_value(
                        curs_id,
                        edge_id_column_list(i),
                        l_json
                     );
                     edge_table.append(l_json);
                  end loop;
               end if;

               p1 := p1 + 1;
               if (
                  page_size is not null
                  and p1 = page_size
               ) then
                  exit;
               end if;
            end if;
         elsif fetch_rows_integer = 0 then
            islastresultset := true;
            exit;
         end if;
      end loop;

      if
         not l_having_element_id
         and counter != 0
      then
         if counter < page_start then
            raise_application_error(
               -20000,
               'page_start index exceeds the total number of rows returned. Please reset page_start to a valid value within the range of available results.'
            );
         ELSIF COUNTER > PAGE_START THEN
            RAISE_APPLICATION_ERROR(-20000, 'Please add vertex_id/edge_id to the COLUMNS clause and project the corresponding column name in the SELECT clause.');
         END IF;
      end if;
      json_file := ora_graph_build_json_using_json_array(
         vertex_table,
         edge_table,
         p1,
         graphname,
         graphowner
      );
      l_json_obj := json_object_t(json_file);
      if islastresultset
      or page_size is null then
         l_json_obj.put(
            'isLastResultSet',
            true
         );
      else
         if p1 < page_size then
            l_json_obj.put(
               'isLastResultSet',
               true
            );
         else
            l_json_obj.put(
               'isLastResultSet',
               false
            );
         end if;
      end if;

      return l_json_obj.to_clob();
   end ora_sqlgraph_to_json;

   