/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import oracle.datastudio.graphviz.gvt.GvtFormatter;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.graphviz.driver.Driver;
import oracle.pgx.graphviz.driver.exception.VisualQueryException;
import oracle.pgx.graphviz.formatter.Result;

public abstract class VisualQuery {
    protected Map<String, Object> driverProperties;
    protected Driver driver;
    protected final GvtFormatter gvtFormatter = new GvtFormatter();

    public VisualQuery() throws VisualQueryException {
        this(Collections.emptyMap());
    }

    public VisualQuery(Map<String, Object> properties) throws VisualQueryException {
        this.driverProperties = properties;
        try {
            this.driver = this.createDriver(properties);
        }
        catch (SQLException | PgqlException e) {
            throw new VisualQueryException(String.format("Failed to construct VisualQuery Object: %s", e.getMessage()), e);
        }
    }

    public String visualizeQuery(String query) throws VisualQueryException {
        return this.visualizeQuery(query, Collections.emptyMap());
    }

    public String visualizeQuery(String query, Map<String, Object> queryProperties) throws VisualQueryException {
        HashMap<String, Object> combinedProperties = new HashMap<String, Object>(this.driverProperties);
        combinedProperties.putAll(queryProperties);
        return this.executeAndVisualizeQuery(query, combinedProperties);
    }

    protected abstract Driver createDriver(Map<String, Object> var1) throws SQLException, PgqlException;

    public void initDriver(Map<String, Object> driverProperties) throws SQLException, PgqlException {
        this.driverProperties = driverProperties;
        this.driver = this.createDriver(driverProperties);
    }

    protected String executeAndVisualizeQuery(String query, Map<String, Object> properties) throws VisualQueryException {
        Optional<Result> optionalResult;
        String graphOwner = (String)properties.get("schema");
        String graphName = (String)properties.get("graphName");
        try {
            optionalResult = this.driver.execute(query, graphOwner, graphName, properties);
        }
        catch (Exception e) {
            throw new VisualQueryException(String.format("Error occurs while visualizing the query: %s", e.getMessage()), e);
        }
        return this.resultToString(optionalResult);
    }

    protected String resultToString(Optional<Result> result) {
        if (result.isPresent()) {
            if (result.get() instanceof Result) {
                Result resultFromExecution = result.get();
                String typeStr = resultFromExecution.getType().toString().toLowerCase();
                String formatted = resultFromExecution.getJson().toString();
                return '%' + typeStr + ' ' + formatted;
            }
            return result.toString();
        }
        return "%text <small><i>Successful execution: No result returned.</i></small>";
    }
}

