/*
 * Decompiled with CFR 0.152.
 */
package pgqllang.strategies;

import java.util.regex.Pattern;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.Strategy;

public class is_invalid_datetime_field_0_0
extends Strategy {
    public static is_invalid_datetime_field_0_0 instance = new is_invalid_datetime_field_0_0();
    private static Pattern decimalPattern = Pattern.compile("[0-9]*['.']?[0-9]*");

    public IStrategoTerm invoke(Context context, IStrategoTerm current) {
        String field;
        IStrategoString valueTerm = (IStrategoString)current.getSubterm(0);
        switch (field = ((IStrategoString)current.getSubterm(1)).stringValue()) {
            case "YEAR": {
                return is_invalid_datetime_field_0_0.parseIntAndCheckBounds(context, valueTerm, Long.MIN_VALUE, Long.MAX_VALUE);
            }
            case "MONTH": {
                return is_invalid_datetime_field_0_0.parseIntAndCheckBounds(context, valueTerm, 0L, 11L);
            }
            case "DAY": {
                return is_invalid_datetime_field_0_0.parseIntAndCheckBounds(context, valueTerm, Long.MIN_VALUE, Long.MAX_VALUE);
            }
            case "HOUR": {
                return is_invalid_datetime_field_0_0.parseIntAndCheckBounds(context, valueTerm, 0L, 23L);
            }
            case "MINUTE": {
                return is_invalid_datetime_field_0_0.parseIntAndCheckBounds(context, valueTerm, 0L, 59L);
            }
            case "SECOND": {
                String message = "Number between 0 and 59.999... expected";
                if (!decimalPattern.matcher(valueTerm.stringValue()).find()) {
                    return is_invalid_datetime_field_0_0.createErrorMessage(context, (IStrategoTerm)valueTerm, message);
                }
                try {
                    double value = Double.parseDouble(valueTerm.stringValue());
                    if (value < 0.0 || value >= 60.0) {
                        return is_invalid_datetime_field_0_0.createErrorMessage(context, (IStrategoTerm)valueTerm, message);
                    }
                }
                catch (NumberFormatException e) {
                    return is_invalid_datetime_field_0_0.createErrorMessage(context, (IStrategoTerm)valueTerm, message);
                }
                return null;
            }
        }
        return null;
    }

    private static IStrategoTerm parseIntAndCheckBounds(Context context, IStrategoString valueTerm, long lowerBound, long upperBound) {
        String message = upperBound == Long.MAX_VALUE ? "Integer expected" : "Integer between " + lowerBound + " and " + upperBound + " expected";
        try {
            long value = Long.parseLong(valueTerm.stringValue());
            if (value < lowerBound || value > upperBound) {
                return is_invalid_datetime_field_0_0.createErrorMessage(context, (IStrategoTerm)valueTerm, message);
            }
        }
        catch (NumberFormatException e) {
            return is_invalid_datetime_field_0_0.createErrorMessage(context, (IStrategoTerm)valueTerm, message);
        }
        return null;
    }

    private static IStrategoTerm createErrorMessage(Context context, IStrategoTerm errorTerm, String message) {
        ITermFactory f = context.getFactory();
        return f.makeAppl(f.makeConstructor("ErrorMessage", 2), new IStrategoTerm[]{errorTerm, f.makeString(message)});
    }
}

