/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.jshell;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jdk.jshell.tool.JavaShellToolBuilder;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.jshell.Arguments;
import oracle.pgx.shell.aargparse.ArgumentParser;
import oracle.pgx.shell.aargparse.ArgumentParsers;
import oracle.pgx.shell.aargparse.exceptions.ArgumentParserException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shell {
    public static final String PROMPT = "pgx> ";
    public static final String CONTINUATION_PROMPT = "...> ";
    public static final String[] IMPORTS = new String[]{"import java.io.*", "import java.math.*", "import java.net.*", "import java.nio.file.*", "import java.util.*", "import java.util.concurrent.*", "import java.util.function.*", "import java.util.prefs.*", "import java.util.regex.*", "import java.util.stream.*", "import oracle.pgx.shell.aargparse.ArgumentParsers", "import org.apache.commons.io.*", "import ch.qos.logback.classic.Level", "import ch.qos.logback.classic.Logger", "import org.slf4j.Logger", "import org.slf4j.LoggerFactory", "import oracle.pgx.common.*", "import oracle.pgx.common.auth.*", "import oracle.pgx.common.mutations.*", "import oracle.pgx.common.types.*", "import oracle.pgx.api.*", "import oracle.pgx.api.admin.*", "import oracle.pgx.config.*", "import oracle.pgx.api.filter.*", "import oracle.pgx.api.PgxGraph.SortOrder", "import oracle.pgx.api.PgxGraph.Degree", "import oracle.pgx.api.PgxGraph.Mode", "import oracle.pgx.api.PgxGraph.SelfEdges", "import oracle.pgx.api.PgxGraph.MultiEdges", "import oracle.pgx.api.PgxGraph.TrivialVertices", "import oracle.pgx.jshell.*"};
    private static final Logger LOG = LoggerFactory.getLogger(Shell.class);

    Shell(String[] imports, String prompt, String continuationPrompt, String[] args) throws Exception {
        this(imports, prompt, continuationPrompt, args, System.out, System.in);
    }

    Shell(String[] imports, String prompt, String continuationPrompt, String[] args, PrintStream stdout, InputStream stdin) throws Exception {
        this(imports, prompt, continuationPrompt, args, stdout, stdin, System::exit);
    }

    Shell(String[] imports, String prompt, String continuationPrompt, String[] args, PrintStream stdout, InputStream stdin, IntConsumer exit) throws Exception {
        ArgumentParser parser = ArgumentParsers.newFor((String)"pgx").build();
        try {
            Arguments arguments = Arguments.parseArgs(parser, args);
            if (arguments.help) {
                parser.printHelp();
                exit.accept(0);
            } else if (arguments.version) {
                parser.printVersion();
            } else if (arguments.script != null) {
                Path startupFile = Shell.replicateStartupScript(imports, prompt, continuationPrompt);
                Path scriptFile = Shell.createScriptFile(arguments);
                System.setProperty("args", Shell.join(args));
                System.setProperty("scriptArgs", Shell.join(arguments.scriptArgs));
                String[] toolArguments = new String[]{"--execution", "local", "--class-path", Shell.getClassPath(), "--startup", startupFile.toString(), scriptFile.toString()};
                int status = JavaShellToolBuilder.builder().in(stdin, null).out(stdout).start(toolArguments);
                exit.accept(status);
            } else {
                Path startupFile = Shell.replicateStartupScript(imports, prompt, continuationPrompt);
                System.setProperty("args", Shell.join(args));
                String[] toolArguments = new String[]{"--execution", "local", "--class-path", Shell.getClassPath(), "--startup", startupFile.toString(), "--feedback", "pgx"};
                JavaShellToolBuilder.builder().in(stdin, null).out(stdout).start(toolArguments);
            }
        }
        catch (ArgumentParserException e) {
            e.getParser().handleError(e);
            exit.accept(-1);
        }
    }

    private static Path replicateStartupScript(String[] imports, String prompt, String continuationPrompt) throws IOException {
        Path tempFile = Files.createTempFile("startup", "jsh", new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        try (InputStream inputStream = Shell.class.getClassLoader().getResourceAsStream("startup.jsh");){
            if (inputStream == null) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"CANNOT_OPEN_STARTUP", (Object[])new Object[0]));
            }
            String startup = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            String delimiter = System.lineSeparator();
            String importsConcat = String.join((CharSequence)delimiter, imports);
            String startupWithImports = startup.replace("@@IMPORTS@@", importsConcat).replace("@@PROMPT@@", prompt).replace("@@CONTINUATION_PROMPT@@", continuationPrompt);
            Files.write(tempFile, startupWithImports.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
            Path path = tempFile;
            return path;
        }
    }

    private static Path createScriptFile(Arguments arguments) throws IOException {
        if (arguments.keepRunning) {
            return arguments.script.toPath();
        }
        Path tempFile = Files.createTempFile("pgx", "jsh", new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        Files.copy(arguments.script.toPath(), tempFile, StandardCopyOption.REPLACE_EXISTING);
        Files.write(tempFile, "\n/exit".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        return tempFile;
    }

    private static String getClassPath() {
        String classpath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        String[] segments = classpath.split(Pattern.quote(separator));
        return Arrays.stream(segments).filter(Shell::validPath).collect(Collectors.joining(separator));
    }

    private static String join(String[] strings) {
        if (strings == null) {
            return "";
        }
        return String.join((CharSequence)" ", strings);
    }

    private static boolean validPath(String path) {
        return Paths.get(path, new String[0]).toFile().exists();
    }

    public static ShellBuilder builder() {
        return new ShellBuilder();
    }

    public static void main(String[] args) throws Exception {
        Shell.builder().withImports(IMPORTS).withPrompt(PROMPT).withContinuationPrompt(CONTINUATION_PROMPT).withArguments(args).run();
    }

    public static class ShellBuilder {
        private String[] imports;
        private String prompt;
        private String continuationPrompt;
        private String[] args;

        public ShellBuilder withImports(String[] imports) {
            this.imports = imports;
            return this;
        }

        public ShellBuilder withPrompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public ShellBuilder withContinuationPrompt(String continuationPrompt) {
            this.continuationPrompt = continuationPrompt;
            return this;
        }

        public ShellBuilder withArguments(String[] args) {
            this.args = args;
            return this;
        }

        public void run() throws Exception {
            if (this.prompt == null) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"JSHELL_PROMPT_MISSING", (Object[])new Object[0]));
            }
            if (this.continuationPrompt == null) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"JSHELL_CONTINUATION_PROMPT_MISSING", (Object[])new Object[0]));
            }
            new Shell(this.imports, this.prompt, this.continuationPrompt, this.args);
        }
    }
}

