/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import oracle.pgx.common.PgxSensitiveDataLogger;
import oracle.pgx.common.auth.TokenProvider;
import org.apache.hc.core5.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableAuthHeader
implements Header {
    private static final Logger LOG = LoggerFactory.getLogger(MutableAuthHeader.class);
    private final TokenProvider authTokenProvider;

    MutableAuthHeader(TokenProvider authTokenProvider) {
        this.authTokenProvider = authTokenProvider;
    }

    public String getName() {
        return "Authorization";
    }

    public String getValue() {
        String token = this.authTokenProvider.getToken();
        if (token == null) {
            return null;
        }
        String headerValue = "Bearer " + token;
        PgxSensitiveDataLogger.trace((Logger)LOG, (String)"setting {} header to {}", (Object)this.getName(), (Object)headerValue);
        return headerValue;
    }

    public boolean isSensitive() {
        return true;
    }
}

