/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal.onprem;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.pg.rdbms.exception.GraphClientException;
import oracle.pg.rdbms.internal.AbstractHttpClient;
import oracle.pg.rdbms.internal.UriUtils;
import oracle.pg.rdbms.internal.onprem.TokenResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;

public class GraphServerClient
extends AbstractHttpClient {
    private static final String CLIENT_STICKY_COOKIE_IDENTIFIER = "PGX_INSTANCE_STICKY_COOKIE";

    public GraphServerClient(HttpClient httpClient) {
        super(httpClient);
    }

    public TokenResponse createToken(String endpoint, String username, String password) throws IOException {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("username", username);
        request.put("password", password);
        return GraphServerClient.parseResponse(this.postJson(GraphServerClient.getTokenUrl(endpoint), request));
    }

    public TokenResponse createToken(String endpoint, String kerberosTicketPath) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(kerberosTicketPath, new String[0]));
        String encodedTicket = Base64.getEncoder().encodeToString(bytes);
        Map<String, Object> request = Collections.singletonMap("kerberosTicket", encodedTicket);
        return GraphServerClient.parseResponse(this.postJson(GraphServerClient.getTokenUrl(endpoint), request));
    }

    public TokenResponse refreshToken(String endpoint, String token) {
        Map<String, Object> request = Collections.singletonMap("token", token);
        return GraphServerClient.parseResponse(this.putJson(GraphServerClient.getTokenUrl(endpoint), request));
    }

    private static URI getTokenUrl(String endpoint) {
        try {
            URI base = new URI(endpoint);
            return UriUtils.appendPath(base, "auth/token");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid URL given", e);
        }
    }

    private static TokenResponse parseResponse(AbstractHttpClient.JsonResponse response) {
        if (response.getStatusCode() == 201) {
            String token = (String)response.getBody().get("access_token");
            if (StringUtils.isEmpty((CharSequence)token)) {
                throw new GraphClientException("failed to obtain token", null);
            }
            return new TokenResponse(token, GraphServerClient.getStickyCookie(response));
        }
        throw new GraphClientException(String.valueOf(response.getBody().get("error_message")), null);
    }

    private static Cookie getStickyCookie(AbstractHttpClient.JsonResponse response) {
        CookieStore cookies = response.getCookies();
        if (cookies != null) {
            return cookies.getCookies().stream().filter(cookie -> cookie.getName().equals(CLIENT_STICKY_COOKIE_IDENTIFIER)).findFirst().orElse(null);
        }
        return null;
    }
}

