/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal.adb;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import oracle.pg.rdbms.AdbGraphClientConfiguration;
import oracle.pg.rdbms.EnvironmentStatus;
import oracle.pg.rdbms.Job;
import oracle.pg.rdbms.exception.GraphClientException;
import oracle.pg.rdbms.internal.AbstractHttpClient;
import oracle.pg.rdbms.internal.UriUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStudioClient
extends AbstractHttpClient {
    private static final Logger log = LoggerFactory.getLogger(GraphStudioClient.class);
    private static final String X_AUTH_TOKEN_HEADER = "x-auth-token";
    private final AdbGraphClientConfiguration config;
    private final ExecutorService executorService;
    private final URI graphStudioUrl;
    private final URI environmentUrl;
    private final URI userUrl;
    private final Supplier<String> tokenSupplier;

    public GraphStudioClient(AdbGraphClientConfiguration config, ExecutorService executorService, URI graphStudioUrl, Supplier<String> tokenSupplier) {
        super(config.getHttpClient());
        this.config = config;
        this.executorService = executorService;
        this.graphStudioUrl = graphStudioUrl;
        this.environmentUrl = UriUtils.appendPath(graphStudioUrl, config.getGraphStudioApiVersion() + "/modeler/environment");
        this.userUrl = UriUtils.appendPath(graphStudioUrl, config.getDataStudioApiVersion() + "/sessions/user");
        this.tokenSupplier = tokenSupplier;
    }

    private Map<String, String> createTokenHeader() {
        return Collections.singletonMap(X_AUTH_TOKEN_HEADER, this.tokenSupplier.get());
    }

    public void getUser() {
        AbstractHttpClient.JsonResponse response = this.getJson(this.userUrl, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to get user (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentStatus getEnvironmentStatus() {
        EnvironmentStatus environmentStatus;
        URI url = UriUtils.appendPath(this.environmentUrl, "status");
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader(X_AUTH_TOKEN_HEADER, (Object)this.tokenSupplier.get());
        log.info("GET {}", (Object)url);
        ClassicHttpResponse response = (ClassicHttpResponse)this.httpClient.execute((ClassicHttpRequest)httpGet);
        try {
            int statusCode = response.getCode();
            if (statusCode != 200) {
                String requestId = GraphStudioClient.getRequestIdFromResponse((HttpResponse)response);
                try {
                    String content = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new GraphClientException("failed to get status (HTTP " + statusCode + "): " + content, requestId);
                }
                catch (ParseException e) {
                    throw new GraphClientException("failed to get status (HTTP " + statusCode + ")", requestId);
                }
            }
            String value = (String)this.objectMapper.readValue(response.getEntity().getContent(), String.class);
            environmentStatus = EnvironmentStatus.valueOf(value);
        }
        catch (Throwable throwable) {
            try {
                GraphStudioClient.close((HttpResponse)response);
                throw throwable;
            }
            catch (IOException e) {
                throw new GraphClientException("could not execute request GET " + url, null, e);
            }
        }
        GraphStudioClient.close((HttpResponse)response);
        return environmentStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getEnvironmentUsedMemory() {
        double d;
        URI url = UriUtils.appendPath(this.environmentUrl, "usedMemory");
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader(X_AUTH_TOKEN_HEADER, (Object)this.tokenSupplier.get());
        log.info("GET {}", (Object)url);
        String requestId = "";
        ClassicHttpResponse response = null;
        try {
            response = (ClassicHttpResponse)this.httpClient.execute((ClassicHttpRequest)httpGet);
            int statusCode = response.getCode();
            if (statusCode != 200) {
                requestId = GraphStudioClient.getRequestIdFromResponse((HttpResponse)response);
                try {
                    String content = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new GraphClientException(MessageFormat.format("failed to get used memory (HTTP {0}}): {1}", statusCode, content), requestId);
                }
                catch (ParseException e) {
                    throw new GraphClientException(MessageFormat.format("failed to get used memory (HTTP {0})", statusCode), requestId);
                }
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            log.debug("response (raw) = {}", (Object)responseBody);
            Map json = (Map)this.objectMapper.readValue(responseBody, Map.class);
            log.debug("response (parsed) = {}", (Object)json);
            d = (Double)json.get("pgxServerMemory");
        }
        catch (IOException e) {
            try {
                throw new GraphClientException(MessageFormat.format("could not execute request GET {0}", url), null, e);
                catch (ParseException e2) {
                    throw new GraphClientException("failed to parse the response", null, e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    GraphStudioClient.close(response);
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new GraphClientException(MessageFormat.format("failed to close response object for url: {0}", url), null, e3);
                }
            }
        }
        try {
            GraphStudioClient.close((HttpResponse)response);
            return d;
        }
        catch (IOException e) {
            throw new GraphClientException(MessageFormat.format("failed to close response object for url: {0}", url), null, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getEnvironmentAvailableMemory() {
        double d;
        URI url = UriUtils.appendPath(this.environmentUrl, "availableMemory");
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader(X_AUTH_TOKEN_HEADER, (Object)this.tokenSupplier.get());
        log.info("GET {}", (Object)url);
        String requestId = "";
        ClassicHttpResponse response = null;
        try {
            double mem;
            response = (ClassicHttpResponse)this.httpClient.execute((ClassicHttpRequest)httpGet);
            int statusCode = response.getCode();
            if (statusCode != 200) {
                requestId = GraphStudioClient.getRequestIdFromResponse((HttpResponse)response);
                try {
                    String content = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw new GraphClientException(MessageFormat.format("failed to get available memory (HTTP {0}}): {1}", statusCode, content), requestId);
                }
                catch (ParseException e) {
                    throw new GraphClientException(MessageFormat.format("failed to get available memory (HTTP {0})", statusCode), requestId);
                }
            }
            log.debug("response (raw) = {}", (Object)response);
            d = mem = ((Double)this.objectMapper.readValue(response.getEntity().getContent(), Double.class)).doubleValue();
        }
        catch (IOException e) {
            try {
                throw new GraphClientException(MessageFormat.format("could not execute request GET {0}", url), null, e);
            }
            catch (Throwable throwable) {
                try {
                    GraphStudioClient.close(response);
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new GraphClientException(MessageFormat.format("failed to close response object for url: {0}", url), null, e2);
                }
            }
        }
        try {
            GraphStudioClient.close((HttpResponse)response);
            return d;
        }
        catch (IOException e) {
            throw new GraphClientException(MessageFormat.format("failed to close response object for url: {0}", url), null, e);
        }
    }

    public Job getJob(long jobId) {
        URI url = UriUtils.appendPath(this.graphStudioUrl, this.config.getGraphStudioApiVersion() + "/modeler/jobs/" + jobId);
        AbstractHttpClient.JsonResponse response = this.getJson(url, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to job status (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
        return this.parseJobResponse(response.getBody());
    }

    public Job attachEnvironment(int memory) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("pgxServerMemory", memory);
        request.put("pgxInterpreterMemory", 1);
        request.put("markdownInterpreterMemory", 1);
        request.put("pythonInterpreterMemory", 1);
        request.put("jdbcInterpreterMemory", 1);
        request.put("condaInterpreterMemory", 1);
        log.info("request: {}", request);
        AbstractHttpClient.JsonResponse response = this.postJson(this.environmentUrl, request, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to attach (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
        return this.parseJobResponse(response.getBody());
    }

    public Job detachEnvironment() {
        AbstractHttpClient.JsonResponse response = this.deleteJson(this.environmentUrl, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to detach (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
        return this.parseJobResponse(response.getBody());
    }

    public Job reattachEnvironment() {
        AbstractHttpClient.JsonResponse response = this.putJson(this.environmentUrl, null, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to restart (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
        return this.parseJobResponse(response.getBody());
    }

    private Job parseJobResponse(Map<String, Object> json) {
        long id = new Long(String.valueOf(json.get("id")));
        String name = String.valueOf(json.get("name"));
        String description = String.valueOf(json.get("description"));
        Job.Type type = Job.Type.valueOf(String.valueOf(json.get("type")));
        Job.Status status = Job.Status.valueOf(String.valueOf(json.get("status")));
        String createdBy = String.valueOf(json.get("createdBy"));
        String error = String.valueOf(json.get("error"));
        List logs = (List)json.get("log");
        ArrayList<Job.LogEntry> logEntries = new ArrayList<Job.LogEntry>();
        if (logs != null) {
            logs.forEach(row -> {
                Date timestamp = new Date(new Long(String.valueOf(row.get("timestamp"))));
                logEntries.add(new Job.LogEntry(timestamp, (String)row.get("log")));
            });
        }
        return new Job(this, id, name, description, type, status, createdBy, error, logEntries);
    }

    public AdbGraphClientConfiguration getConfig() {
        return this.config;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

