/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.pypgx.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.CompiledProgram;
import oracle.pgx.api.PgxEntity;
import oracle.pgx.api.Property;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.internal.AnalysisResult;
import oracle.pgx.api.mllib.DeepWalkModel;
import oracle.pgx.api.mllib.Pg2vecModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyjniusHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PyjniusHelper.class);

    public static <T> AnalysisResult<T> runFromPython(CompiledProgram compiledProgram, Object ... args) throws ExecutionException, InterruptedException {
        return compiledProgram.run(args);
    }

    public static <K extends PgxEntity<?>, V> V getFromPropertyByKey(Property<?, K, V> property, K key) {
        return (V)property.get(key);
    }

    public static PgxFrame computeSimilarsList(DeepWalkModel model, List<Object> vertexIds, int k) throws ExecutionException, InterruptedException {
        return model.computeSimilars(vertexIds, k);
    }

    public static PgxFrame computeSimilarsList(Pg2vecModel model, List<Object> vertexIds, int k) throws ExecutionException, InterruptedException {
        return model.computeSimilars(vertexIds, k);
    }

    public static Object reflectInvokeMethod(Object o, String methodName) throws Exception {
        Method m = PyjniusHelper.tryFindInterfaceMethod(o.getClass().getMethod(methodName, null));
        m.setAccessible(true);
        return PyjniusHelper.convertObject(m.invoke(o, new Object[0]));
    }

    private static Method tryFindInterfaceMethod(Method m) throws Exception {
        for (Class<?> interfaceClass : m.getDeclaringClass().getInterfaces()) {
            try {
                return interfaceClass.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException ignore) {
                LOG.trace("Method {} was not found in {}", (Object)m, interfaceClass);
            }
        }
        return m;
    }

    private static Object convertObject(Object value) {
        if (value instanceof Character) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BooleanEnum.TRUE : BooleanEnum.FALSE;
        }
        return value;
    }

    static enum BooleanEnum {
        FALSE,
        TRUE;

    }
}

