/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver.pgxPreparedStatement;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.pgx.common.types.IdType;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.Operator;

public class PgxPreparedStatementUtils {
    public static List<?> getListIds(String[] ids, IdType idType) {
        Stream<String> idStream = Stream.of(ids);
        return idStream.map(id -> idType.parse(id)).collect(Collectors.toList());
    }

    public static String joiningConditions(List<StringBuilder> conditions, String operator) {
        Operator op = Operator.valueOf(operator.toUpperCase());
        return conditions.stream().map(Object::toString).collect(Collectors.joining(op.toJoiningString()));
    }

    public static String getExpandMatchClause(int hops, String sourceVertexIdentifier, String edgeIdentifier) {
        String repeatedHops = "";
        while (hops > 1) {
            repeatedHops = String.format("%s()-", repeatedHops);
            --hops;
        }
        return String.format("(%s)-%s[%s]-()", sourceVertexIdentifier, repeatedHops, edgeIdentifier);
    }

    public static String formatPropertyName(String propertyName) {
        return propertyName.replaceAll("\"", "\"\"");
    }
}

