/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver.pgxPreparedStatement;

import java.util.ArrayList;
import java.util.List;
import oracle.gvt.models.ExpandCondition;
import oracle.gvt.models.ExpandConditions;
import oracle.gvt.models.ExpandTemplate;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxPreparedStatement;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.graphviz.driver.exception.VisualizationException;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.ConditionOperator;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.PgxPreparedStatementUtils;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.ArrayParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.Parameter;

public class PgxPreparedStatementExpandQueryBuilder {
    private PgxGraph graph;
    private List<StringBuilder> navigationsConditions = new ArrayList<StringBuilder>();
    private String navigationsOperator;
    private List<StringBuilder> destinationsConditions = new ArrayList<StringBuilder>();
    private String destinationsOperator;
    private List<Parameter<?>> parameters = new ArrayList();
    private int lastPosition = 1;
    private String hops = "*";
    private String query;
    public static final String VERTEX = "v";
    public static final String SOURCE_VERTEX = "s";
    public static final String EDGE = "e";
    public static final String DESTINATION = "d";
    public static final String NAVIGATION = "n";
    public static final String EDGES_LIMIT = "100";
    private static final String EXPAND_QUERY = "SELECT DISTINCT id(e) FROM MATCH %s WHERE id(s) IN ? LIMIT 100";
    private static final String SMART_EXPAND_QUERY = "SELECT ARRAY_AGG(DISTINCT id(ne)) AS edges FROM \"%s\"  MATCH ALL SHORTEST((s) (-[ne]-(nv) %s)%s (dv)), ()-[de]-(dv) WHERE (id(s) IN ? ) %s";

    public PgxPreparedStatementExpandQueryBuilder(PgxGraph graph) {
        this.graph = graph;
    }

    public void addVertices(String[] selectedVertices) {
        this.parameters.add(new ArrayParameter(this.lastPosition, PgxPreparedStatementUtils.getListIds(selectedVertices, this.graph.getVertexIdType())));
        ++this.lastPosition;
    }

    public void setExpandTemplate(String[] selectedVertices, ExpandTemplate expandTemplate) throws VisualizationException {
        IdType edgeIDType;
        IdType vertexIdType = this.graph.getVertexIdType();
        IdType idType = edgeIDType = this.graph.getEdgeIdStrategy().equals((Object)IdStrategy.PARTITIONED_IDS) ? IdType.STRING : this.graph.getMetaData().getEdgeIdType();
        if (expandTemplate.getNumberOfHops() != null) {
            this.hops = String.format("{,%d}", expandTemplate.getNumberOfHops());
        }
        this.setSmartExpandPgqlWhereClause(NAVIGATION, expandTemplate.getNavigation(), vertexIdType, edgeIDType, this.navigationsConditions);
        this.navigationsOperator = expandTemplate.getNavigation().getOperator();
        this.addVertices(selectedVertices);
        this.setSmartExpandPgqlWhereClause(DESTINATION, expandTemplate.getDestination(), vertexIdType, edgeIDType, this.destinationsConditions);
        this.destinationsOperator = expandTemplate.getDestination().getOperator();
    }

    private void setSmartExpandPgqlWhereClause(String prefix, ExpandConditions expandConditions, IdType vertexIdType, IdType edgeIDType, List<StringBuilder> queryConditions) throws VisualizationException {
        for (ExpandCondition condition : expandConditions.getConditions()) {
            IdType type;
            String operator;
            StringBuilder resultingString = new StringBuilder();
            boolean isVertexComponent = condition.getComponent().equals("vertex");
            String name = prefix + (isVertexComponent ? VERTEX : EDGE);
            String conditionOperator = ConditionOperator.validateOperator(condition.getOperator());
            boolean isNotEqualsOperator = conditionOperator.equals("!=");
            String string = operator = isNotEqualsOperator ? "<>" : conditionOperator;
            if (condition.getProperty().equals("id")) {
                type = isVertexComponent ? vertexIdType : edgeIDType;
                resultingString.append(String.format("id( %s ) %s ?", name, operator));
                this.parameters.add(Parameter.createParameter(condition.getValue(), type, this.lastPosition));
            } else if (condition.getProperty().equals("label")) {
                resultingString.append(isNotEqualsOperator ? "not " : "");
                resultingString.append("has_label(").append(name).append(", ?)");
                this.parameters.add(Parameter.createParameter(condition.getValue(), PropertyType.STRING, this.lastPosition));
            } else {
                type = this.getPropertyType(condition);
                resultingString.append(name);
                resultingString.append(".").append('\"').append(PgxPreparedStatementUtils.formatPropertyName(condition.getProperty())).append('\"').append(" ");
                resultingString.append(conditionOperator);
                resultingString.append(" ?");
                this.parameters.add(Parameter.createParameter(condition.getValue(), (PropertyType)type, this.lastPosition));
            }
            queryConditions.add(resultingString);
            ++this.lastPosition;
        }
    }

    public PgxPreparedStatement buildForExpand(int hops) throws PgqlException {
        this.query = String.format(EXPAND_QUERY, PgxPreparedStatementUtils.getExpandMatchClause(hops, SOURCE_VERTEX, EDGE));
        return this.getPgxPreparedStatement();
    }

    public PgxPreparedStatement buildForSmartExpand() throws PgqlException {
        String graphName = this.graph.getName();
        String navigation = PgxPreparedStatementUtils.joiningConditions(this.navigationsConditions, this.navigationsOperator);
        navigation = navigation.length() > 0 ? String.format("WHERE %s", navigation) : "";
        String destination = PgxPreparedStatementUtils.joiningConditions(this.destinationsConditions, this.destinationsOperator);
        destination = destination.length() > 0 ? String.format("AND (%s)", destination) : "";
        this.query = String.format(SMART_EXPAND_QUERY, graphName, navigation, this.hops, destination);
        return this.getPgxPreparedStatement();
    }

    private PgxPreparedStatement getPgxPreparedStatement() throws PgqlException {
        PgxPreparedStatement pgxPreparedStatement = this.graph.preparePgql(this.query);
        for (Parameter<?> parameter : this.parameters) {
            parameter.bindValue(pgxPreparedStatement);
        }
        return pgxPreparedStatement;
    }

    private PropertyType getPropertyType(ExpandCondition condition) {
        if (condition.getComponent().equals("vertex")) {
            return this.graph.getVertexProperty(condition.getProperty()).getType();
        }
        return this.graph.getEdgeProperty(condition.getProperty()).getType();
    }
}

