/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxPreparedStatement;
import oracle.pgx.graphviz.driver.Driver;
import oracle.pgx.graphviz.driver.PgxDriver;
import oracle.pgx.graphviz.driver.VisualQuery;
import oracle.pgx.graphviz.driver.exception.VisualQueryException;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.Parameter;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Formatter;
import oracle.pgx.graphviz.formatter.Pair;
import oracle.pgx.graphviz.formatter.Result;
import oracle.pgx.graphviz.library.QueryEnhancer;
import oracle.pgx.graphviz.library.QueryEnhancerUtils;
import oracle.pgx.graphviz.library.TableOnlyResultSet;
import oracle.pgx.graphviz.library.VisualResultSet;
import oracle.pgx.graphviz.library.enhancer.Enhancement;
import oracle.pgx.graphviz.library.enhancer.Enhancer;
import oracle.pgx.graphviz.library.misc.MalformedQueryException;

public class PgxVisualQuery
extends VisualQuery {
    private PgxGraph pgxGraph;
    private List<Parameter<?>> parameters;
    private QueryEnhancer queryEnhancer;

    public PgxVisualQuery() throws PgqlException, VisualQueryException {
        this.queryEnhancer = new QueryEnhancer(this.driver, (Formatter)this.gvtFormatter);
    }

    public PgxVisualQuery(Map<String, Object> properties) throws PgqlException, VisualQueryException {
        super(properties);
        this.queryEnhancer = new QueryEnhancer(this.driver, (Formatter)this.gvtFormatter);
    }

    protected Driver createDriver(Map<String, Object> driverProperties) throws PgqlException {
        Driver driver = (Driver)driverProperties.get("oracle.pgx.graphviz.custom-driver");
        if (driver != null) {
            return driver;
        }
        return new PgxDriver(driverProperties);
    }

    protected Result preparedStatementQuery(PgxGraph graph, String queryString, List<Parameter<?>> parameters, Map<String, Object> properties) throws Exception {
        GraphQuery query;
        Enhancer enhancer;
        String graphName = graph.getName();
        String schema = null;
        try {
            enhancer = this.queryEnhancer.createEnhancer(queryString, null, graphName, properties);
        }
        catch (PgqlException e) {
            throw new VisualQueryException(String.format("Failed to parse the query: %s", queryString), (Throwable)e);
        }
        catch (SQLException e) {
            throw new VisualQueryException((Throwable)e);
        }
        List header = enhancer.getOriginalHeader();
        Pair canViz = enhancer.checkIfVisualizable();
        if (((Boolean)canViz.getFirst()).booleanValue()) {
            Enhancement enhancement = enhancer.enhance();
            String enhancedQuery = "/*ALLOW_REFERENCING_ANY_PROPERTY*/ " + enhancement.getQuery().toString();
            try {
                PgqlResultSet queryResultSet = this.executePreparedStatementQuery(graph, enhancedQuery, parameters, properties);
                return this.gvtFormatter.format((EnhancedResultSet)new VisualResultSet((ResultSet)queryResultSet, enhancement, schema, header, this.driver.isDirectedSupported(), this.driver.supportsMultipleIterations()), properties);
            }
            catch (PgqlException e) {
                throw new VisualQueryException(String.format("Failed to execute the query: %s", queryString), (Throwable)e);
            }
            catch (IOException e) {
                throw new VisualQueryException("Error occurs while formating the query result", (Throwable)e);
            }
        }
        try {
            query = QueryEnhancerUtils.parseQuery((String)queryString, null, (String)graphName);
        }
        catch (PgqlException | MalformedQueryException e) {
            throw new VisualQueryException(String.format("Failed to excute the query: %s", queryString), e);
        }
        String parsedQueryString = query.toString();
        try {
            PgqlResultSet queryResultSet = this.executePreparedStatementQuery(graph, parsedQueryString, parameters, properties);
            return this.gvtFormatter.format((EnhancedResultSet)new TableOnlyResultSet((ResultSet)queryResultSet, graphName, null, header, this.driver.supportsMultipleIterations()), properties);
        }
        catch (PgqlException e) {
            throw new VisualQueryException(String.format("Failed to parse the query: %s", queryString), (Throwable)e);
        }
        catch (IOException e) {
            throw new VisualQueryException("Error occurs while formating the query result", (Throwable)e);
        }
    }

    public PgqlResultSet executePreparedStatementQuery(PgxGraph graph, String query, List<Parameter<?>> parameters, Map<String, Object> properties) throws PgqlException {
        PgxPreparedStatement pgxPreparedStatement = graph.preparePgql(query);
        for (Parameter<?> parameter : parameters) {
            parameter.bindValue(pgxPreparedStatement);
        }
        return pgxPreparedStatement.executeQuery();
    }

    public void setPgxGraph(PgxGraph graph) {
        this.pgxGraph = graph;
    }

    public void setParameters(List<Parameter<?>> parameters) {
        this.parameters = parameters;
    }

    public void initDriver(Map<String, Object> driverProperties) throws SQLException, PgqlException {
        super.initDriver(driverProperties);
        this.queryEnhancer = new QueryEnhancer(this.driver, (Formatter)this.gvtFormatter);
    }

    protected String executeAndVisualizeQuery(String query, Map<String, Object> properties) throws VisualQueryException {
        Optional optionalResult;
        try {
            properties.put("query_enhancer", this.queryEnhancer);
            String graphOwner = (String)properties.get("schema");
            String graphName = (String)properties.get("graphName");
            if (this.pgxGraph != null) {
                ArrayList paramsToUse = this.parameters != null ? this.parameters : new ArrayList();
                Optional<Result> result = Optional.of(this.preparedStatementQuery(this.pgxGraph, query, paramsToUse, properties));
                String resultStr = this.resultToString(result);
                return resultStr;
            }
            optionalResult = this.driver.execute(query, graphOwner, graphName, properties);
        }
        catch (Exception e) {
            throw new VisualQueryException(String.format("Error occurs while visualizing the query: %s", e.getMessage()), (Throwable)e);
        }
        return this.resultToString(optionalResult);
    }

    public String queryPgql(String query) throws VisualQueryException {
        return this.visualizeQuery(query);
    }

    public String queryPgql(String query, Map<String, Object> queryProperties) throws VisualQueryException {
        return this.visualizeQuery(query, queryProperties);
    }
}

