/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.graphviz.pgql.AbstractPgqlDriver;
import oracle.gvt.models.DynamicForms;
import oracle.gvt.models.ExpandTemplate;
import oracle.gvt.models.GraphState;
import oracle.gvt.models.ResultBoth;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgx.api.Namespace;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.api.ServerInstanceHelper;
import oracle.pgx.common.VersionInfo;
import oracle.pgx.common.auth.AuthorizationException;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.graphviz.driver.CursorWrapper;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.GraphName;
import oracle.pgx.graphviz.driver.PgxGraphInformation;
import oracle.pgx.graphviz.driver.PgxServerInstanceProvider;
import oracle.pgx.graphviz.driver.PgxSessionWrapper;
import oracle.pgx.graphviz.driver.PgxVisualization;
import oracle.pgx.graphviz.driver.exception.CursorException;
import oracle.pgx.graphviz.driver.exception.GetGraphInformationException;
import oracle.pgx.graphviz.driver.exception.VisualizationException;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Pair;
import oracle.pgx.graphviz.library.enhancer.Enhancement;
import oracle.pgx.graphviz.library.enhancer.Enhancer;
import oracle.pgx.realm.client.RealmClient;

public class PgxDriver
extends AbstractPgqlDriver
implements PgxServerInstanceProvider {
    public static final String CUSTOM_DRIVER = "oracle.pgx.graphviz.custom-driver";
    public static final String DEFAULT_SESSION_SOURCE = "oracle.pgx.graphviz.pgxdriver";
    public static final String REALM_CLIENT_CLASS_NAME = "graphviz.driver.realm-client-class-name";
    public static final String PGX_SESSION = "graphviz.driver.pgx-session";
    public static final String BASE_URL = "base_url";
    public static final String GET_LATEST_GRAPH_SNAPSHOT = "get_latest_graph_snapshot";
    private static boolean getLatestSnapshot;

    public PgxDriver(Map<String, Object> properties) {
        super(properties);
        try {
            getLatestSnapshot = (Boolean)properties.getOrDefault(GET_LATEST_GRAPH_SNAPSHOT, true);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Could not parse property get_latest_graph_snapshot");
        }
    }

    @Override
    public ServerInstance connect(Map<String, Object> properties) {
        String realmClientClassName;
        Properties localProperties = new Properties();
        Map<String, Object> filtered = properties.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        localProperties.putAll(filtered);
        ClientConfig clientConfig = ClientConfig.parse((Properties)localProperties, (boolean)true);
        String accessToken = (String)localProperties.get("graphviz.driver.access-token");
        if (accessToken != null) {
            LOG.debug("Setting token for client");
            clientConfig.getValues().put(ClientConfig.Field.ACCESS_TOKEN, accessToken);
        }
        if ((realmClientClassName = (String)properties.get(REALM_CLIENT_CLASS_NAME)) != null) {
            try {
                LOG.info("Loading realm client {}", (Object)realmClientClassName);
                Class<?> realmClientClass = Class.forName(realmClientClassName);
                RealmClient realmClient = (RealmClient)realmClientClass.getDeclaredConstructor(Map.class).newInstance(localProperties);
                realmClient.setToken(accessToken);
                return ServerInstanceHelper.getInstance(clientConfig, realmClient);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                throw new RuntimeException("could not instantiate realm client", e2);
            }
        }
        return ServerInstanceHelper.getInstance(clientConfig);
    }

    private void setLatestSnapshot(PgxGraph graph, PgxSession session) throws InterruptedException, ExecutionException {
        if (getLatestSnapshot) {
            if (graph.isPublishedWithSnapshots()) {
                session.setSnapshot(graph, -1L);
            } else if (session.getAvailableSnapshots(graph).size() > 1) {
                session.setSnapshot(graph, -1L, true);
            }
        }
    }

    protected PgxSessionWrapper getOrCreateSession(Map<String, Object> properties) {
        try {
            String parallelism;
            String sessionId = null;
            if (properties != null) {
                sessionId = (String)properties.get("graphviz.driver.session");
            }
            boolean keepOpen = true;
            PgxSession session = (PgxSession)properties.get(PGX_SESSION);
            if (session == null) {
                ServerInstance instance = this.connect(properties);
                if (sessionId != null) {
                    session = instance.getSession(sessionId);
                    if (session == null) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SESSION_NOT_FOUND", (Object[])new Object[]{sessionId}));
                    }
                    keepOpen = true;
                } else {
                    session = instance.createSession(DEFAULT_SESSION_SOURCE);
                    keepOpen = false;
                }
            }
            if ((parallelism = (String)properties.get("parallelism")) != null) {
                int threadsPerTask = Integer.parseInt(parallelism);
                session.getExecutionEnvironment().getAnalysisEnvironment().setMaxNumThreads(Integer.valueOf(threadsPerTask));
            }
            return new PgxSessionWrapper(session, keepOpen);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private PgxGraph getGraphFromPgqlGraphRef(PgxSession session, String pgqlGraphRef) throws ExecutionException, InterruptedException {
        Namespace[] namespaceOrder = new Namespace[]{Namespace.PRIVATE, Namespace.PUBLIC};
        boolean matchCaseInsensitive = pgqlGraphRef.equals(pgqlGraphRef.toUpperCase());
        try {
            for (Namespace namespace : namespaceOrder) {
                List graphNamesInNamespace = session.getGraphs(namespace);
                if (graphNamesInNamespace.contains(pgqlGraphRef)) {
                    return session.getGraph(namespace, pgqlGraphRef);
                }
                if (!matchCaseInsensitive) continue;
                for (String graphName : graphNamesInNamespace) {
                    if (!graphName.toUpperCase().equals(pgqlGraphRef)) continue;
                    return session.getGraph(namespace, graphName);
                }
            }
            return null;
        }
        catch (ExecutionException e) {
            Exception cause;
            if (Objects.nonNull(e) && Objects.nonNull(e.getCause()) && (cause = (Exception)e.getCause()).getClass() == AuthorizationException.class) {
                return null;
            }
            throw e;
        }
    }

    @Nonnull
    public EnhancedResultSet query(@Nonnull String pgqlQuery, String graphName, @Nullable String schema, Map<String, Object> properties) throws PgqlException {
        PgxSessionWrapper session = this.getOrCreateSession(properties);
        try {
            Enhancer enhancer = (Enhancer)properties.get("enhancer");
            Pair canViz = enhancer.checkIfVisualizable();
            List header = enhancer.getOriginalHeader();
            properties.put("original_header", header);
            if (((Boolean)canViz.getFirst()).booleanValue()) {
                Enhancement enhancement = enhancer.enhance();
                pgqlQuery = "/*ALLOW_REFERENCING_ANY_PROPERTY*/ " + enhancement.getQuery();
                properties.put("enhancement", enhancement);
            }
            PgxGraph graph = this.getGraphFromPgqlGraphRef(session.getSession(), graphName);
            this.setLatestSnapshot(graph, session.getSession());
            PgqlResultSet rs = session.getSession().queryPgql((String)pgqlQuery);
            EnhancedResultSet enhancedResultSet = super.getEnhancedResultSet((ResultSet)rs, schema, graphName, ((Boolean)canViz.getFirst()).booleanValue(), this.isDirectedSupported(), this.supportsMultipleIterations(), properties);
            if (session != null) {
                session.close();
            }
            return enhancedResultSet;
        }
        catch (Throwable throwable) {
            try {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PgqlException((Throwable)e);
            }
        }
    }

    private void executeCreateOrModify(@Nonnull String query, Map<String, Object> properties) throws PgqlException {
        try (PgxSessionWrapper session = this.getOrCreateSession(properties);){
            session.getSession().executePgql(query);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PgqlException((Throwable)e);
        }
    }

    @Nonnull
    public String create(@Nonnull String query, Map<String, Object> properties) throws PgqlException, SQLException {
        this.executeCreateOrModify(query, properties);
        return "Graph successfully created. Note: The graph is created in-memory in Graph Server and is transient. It is accessible only in this session and will be destroyed when this session is closed.";
    }

    @Nonnull
    public String modify(@Nonnull String pgqlQuery, String graphName, Map<String, Object> properties) throws PgqlException {
        this.executeCreateOrModify(pgqlQuery, properties);
        return "";
    }

    public Collection<GraphName> getGraphs(Map<String, Object> properties) {
        PgxSessionWrapper sessionWrapper = this.getOrCreateSession(properties);
        try {
            PgxSession session = sessionWrapper.getSession();
            HashSet graphNames = new HashSet();
            for (Namespace ns : Arrays.asList(Namespace.PUBLIC, Namespace.PRIVATE)) {
                graphNames.addAll(session.getGraphs(ns).stream().map(g -> new GraphName(g)).collect(Collectors.toSet()));
            }
            HashSet hashSet = graphNames;
            if (sessionWrapper != null) {
                sessionWrapper.close();
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            try {
                if (sessionWrapper != null) {
                    try {
                        sessionWrapper.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nonnull
    public GraphInformation getGraph(@Nullable String schemaName, @Nonnull String name, Map<String, Object> properties) {
        PgxSessionWrapper session = this.getOrCreateSession(properties);
        try {
            PgxGraph graph = this.getGraphFromPgqlGraphRef(session.getSession(), name);
            if (graph == null) {
                throw new NoSuchElementException(String.format("The graph named %s does not exist or is not accessible for session: %s", name, session.toString()));
            }
            this.setLatestSnapshot(graph, session.getSession());
            PgxGraphInformation pgxGraphInformation = new PgxGraphInformation(graph);
            if (session != null) {
                session.close();
            }
            return pgxGraphInformation;
        }
        catch (Throwable throwable) {
            try {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getVersion(Map<String, Object> properties) throws SQLException {
        return VersionInfo.getInstance((String)"sm").getReleaseVersion();
    }

    public void close() throws Exception {
    }

    public ResultBoth expandGraph(@Nullable String schema, String graphName, String[] selectedVertices, int hops, DynamicForms dynamicFormsParams, Map<String, Object> properties) throws VisualizationException {
        ResultBoth resultBoth = null;
        try (PgxSessionWrapper session = this.getOrCreateSession(properties);){
            PgxVisualization visualization;
            try {
                visualization = new PgxVisualization(session.getSession(), properties);
            }
            catch (Exception e) {
                throw new IllegalStateException("Not able to initialize PgxVisualization", e);
            }
            String result = visualization.expandGraph(graphName, selectedVertices, hops, dynamicFormsParams);
            if (result.contains("%network ")) {
                result = result.substring("%network ".length(), result.length());
            }
            try {
                resultBoth = (ResultBoth)mapper.readValue(result, ResultBoth.class);
            }
            catch (JsonProcessingException e) {
                LOG.info("Error during graphs schema mapping", (Throwable)e);
                throw new IllegalArgumentException("JSON Schema returned by the database was invalid.");
            }
            resultBoth.setResultType(ResultBoth.ResultTypeEnum.GRAPH_AND_TABLE);
            ResultBoth resultBoth2 = resultBoth;
            return resultBoth2;
        }
    }

    public String smartExpandGraph(@Nullable String schema, String graphName, String[] selectedVertices, ExpandTemplate expandTemplate, DynamicForms dynamicFormsParams, Map<String, Object> properties) throws VisualizationException {
        try (PgxSessionWrapper session = this.getOrCreateSession(properties);){
            PgxVisualization visualization;
            try {
                visualization = new PgxVisualization(session.getSession(), properties);
            }
            catch (Exception e) {
                throw new IllegalStateException("Not able to initialize PgxVisualization", e);
            }
            String string = visualization.smartExpandGraph(graphName, selectedVertices, expandTemplate, dynamicFormsParams);
            return string;
        }
    }

    public CursorWrapper createCursorWrapper(String connectionId, String query, Map<String, Object> properties) throws CursorException {
        throw new UnsupportedOperationException("This operation is only available for SQL property graphs.");
    }

    public Future<CursorWrapper> createCursorWrapperAsync(String connectionId, String query, Map<String, Object> properties) throws CursorException {
        throw new UnsupportedOperationException("This operation is only available for SQL property graphs.");
    }

    public oracle.gvt.models.GraphInformation getGraphInformation(String graphName, @Nullable String schemaName, Map<String, Object> properties) throws GetGraphInformationException {
        PgxSessionWrapper session = this.getOrCreateSession(properties);
        try {
            PgxGraph graph = this.getGraphFromPgqlGraphRef(session.getSession(), graphName);
            if (graph == null) {
                throw new NoSuchElementException(String.format("The graph named %s does not exist or is not accessible for session: %s", graphName, session.toString()));
            }
            oracle.gvt.models.PgxGraphInformation information = new oracle.gvt.models.PgxGraphInformation();
            PgxGraphInformation information2 = new PgxGraphInformation(graph);
            information.setState(GraphState.MEMORY);
            information.setEdgeLabels(information2.getEdgeLabels().stream().collect(Collectors.toList()));
            information.setEdgeProperties(information2.getEdgeProperties().stream().map(p -> p.getName()).collect(Collectors.toList()));
            information.setVertexLabels(information2.getVertexLabels().stream().collect(Collectors.toList()));
            information.setVertexProperties(information2.getVertexProperties().stream().map(p -> p.getName()).collect(Collectors.toList()));
            information.setNumEdges(Integer.valueOf((int)graph.getNumEdges()));
            information.setNumVertices(Integer.valueOf((int)graph.getNumVertices()));
            oracle.gvt.models.PgxGraphInformation pgxGraphInformation = information;
            if (session != null) {
                session.close();
            }
            return pgxGraphInformation;
        }
        catch (Throwable throwable) {
            try {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new GetGraphInformationException((Throwable)e);
            }
        }
    }
}

