/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.parallel.stratego_parallel;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelAll;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelContext;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJobAbortedException;

public class ParallelJob
implements Runnable,
Comparable<ParallelJob> {
    public static final int COMPLETED_FOCUS_INDEX = Integer.MAX_VALUE;
    private final Context parentContext;
    private final Strategy strategy;
    private final IStrategoTerm[] inputs;
    private final IStrategoTerm[] outputs;
    private final AtomicInteger focusIndex;
    private final AtomicBoolean isAborted;
    private final AtomicReference<String> lastSynchronousOperation;
    private final AtomicReference<Throwable> lastException;
    private final boolean allowUnordered;
    private final int startIndex;
    private final int jobLength;
    private final int parallelismLevel;
    private final AtomicInteger jobsCompleted;
    private boolean isFocusJob;

    public ParallelJob(Context parentContext, Strategy strategy, IStrategoTerm[] inputs, IStrategoTerm[] outputs, AtomicInteger focusIndex, AtomicBoolean isAborted, AtomicReference<String> lastSynchronousOperation, AtomicReference<Throwable> lastException, boolean allowUnordered, int startIndex, int jobLength, int parallelismLevel, AtomicInteger jobsCompleted) {
        this.parentContext = parentContext;
        this.strategy = strategy;
        this.inputs = inputs;
        this.outputs = outputs;
        this.focusIndex = focusIndex;
        this.isAborted = isAborted;
        this.lastSynchronousOperation = lastSynchronousOperation;
        this.lastException = lastException;
        this.allowUnordered = allowUnordered;
        this.startIndex = startIndex;
        this.jobLength = jobLength;
        this.parallelismLevel = parallelismLevel;
        this.jobsCompleted = jobsCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        int end = Math.min(this.inputs.length, this.startIndex + this.jobLength);
        ParallelContext context = new ParallelContext(this.parentContext, this, this.isAborted, this.allowUnordered);
        int i = this.startIndex;
        while (i < end) {
            IStrategoTerm result = this.execute(context, this.inputs[i]);
            if (result == null) break;
            this.outputs[i] = result;
            ++i;
        }
        this.updateFocusIndex();
        AtomicInteger atomicInteger = this.jobsCompleted;
        synchronized (atomicInteger) {
            this.jobsCompleted.incrementAndGet();
            this.jobsCompleted.notifyAll();
        }
    }

    public final AtomicInteger getFocusIndex() {
        return this.focusIndex;
    }

    protected final Object getFocusIndexMonitor() {
        return this.focusIndex;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    private void updateFocusIndex() {
        if (this.focusIndex.get() == Integer.MAX_VALUE) {
            return;
        }
        this.focusIndex.set(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStrategoTerm execute(ParallelContext context, IStrategoTerm input) {
        if (this.isAborted.get()) {
            return null;
        }
        IStrategoTerm result = null;
        try {
            result = this.strategy.invoke(context, input);
        }
        catch (ParallelJobAbortedException parallelJobAbortedException) {
        }
        catch (RuntimeException e) {
            this.lastException.set(e);
        }
        catch (Error e) {
            this.lastException.set(e);
        }
        if (result == null) {
            this.isAborted.set(true);
            this.getFocusIndex().set(Integer.MAX_VALUE);
            ParallelAll.instance.getExecutor().getQueue().clear();
            Object object = this.getFocusIndexMonitor();
            synchronized (object) {
                this.getFocusIndexMonitor().notifyAll();
            }
        }
        return result;
    }

    public boolean isFocusJob() {
        return this.isFocusJob || this.focusIndex.get() == this.startIndex;
    }

    public void waitForFocus() throws InterruptedException {
        if (!this.isFocusJob) {
            this.waitForFocusIndexAndComplain();
            this.isFocusJob = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFocusIndexAndComplain() throws InterruptedException {
        System.out.print("$?");
        if (this.focusIndex.get() < this.startIndex) {
            Object monitor;
            Object object = monitor = this.getFocusIndexMonitor();
            synchronized (object) {
                this.updateFocusIndex();
                while (this.focusIndex.get() < this.startIndex) {
                    monitor.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCompletedFocusIndex() throws InterruptedException {
        Object monitor;
        int SPINWAIT_CYCLES = 1000;
        int i = 0;
        while (i < SPINWAIT_CYCLES) {
            if (this.focusIndex.get() == Integer.MAX_VALUE) {
                return;
            }
            ++i;
        }
        System.out.print("$??");
        Object object = monitor = this.getFocusIndexMonitor();
        synchronized (object) {
            while (this.focusIndex.get() != Integer.MAX_VALUE) {
                monitor.wait();
            }
        }
    }

    @Override
    public int compareTo(ParallelJob o) {
        if (this.parallelismLevel > o.parallelismLevel) {
            return -1;
        }
        if (this.parallelismLevel == o.parallelismLevel) {
            return this.startIndex < o.startIndex ? -1 : (this.startIndex == o.startIndex ? 0 : 1);
        }
        return 1;
    }
}

