/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.gradual;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.strategoxt.lang.gradual.Type;

public class AllOf
implements Type {
    public final Set<Type> types;

    public AllOf(Set<Type> types) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Types in AllOf may not be empty");
        }
        this.types = new HashSet<Type>();
        for (Type type : types) {
            if (type instanceof AllOf) {
                this.types.addAll(((AllOf)type).types);
                continue;
            }
            this.types.add(type);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.types.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllOf other = (AllOf)obj;
        return this.types.equals(other.types);
    }

    @Override
    public String toString() {
        StringBuilder typesStringBuilder = new StringBuilder();
        Iterator<Type> iterator = this.types.iterator();
        while (true) {
            typesStringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) break;
            typesStringBuilder.append(", ");
        }
        return "allOf(" + typesStringBuilder + ")";
    }
}

