/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.compat;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import org.strategoxt.lang.StrategoException;

public class NativeCallHelper {
    public int call(String[] commandArgs, File workingDir, PrintStream outStream, PrintStream errorStream) throws InterruptedException, IOException {
        return this.call(commandArgs, null, workingDir, outStream, errorStream);
    }

    public int call(String[] commandArgs, File workingDir, Writer outStream, Writer errorStream) throws InterruptedException, IOException {
        return this.call(commandArgs, null, workingDir, outStream, errorStream);
    }

    public int call(String[] commandArgs, String[] environment, File workingDir, PrintStream outStream, PrintStream errorStream) throws InterruptedException, IOException {
        return this.call(commandArgs, environment, workingDir, new OutputStreamWriter(outStream), new OutputStreamWriter(errorStream));
    }

    public int call(String[] commandArgs, String[] environment, File workingDir, Writer outWriter, Writer errorWriter) throws InterruptedException, IOException {
        Process process = Runtime.getRuntime().exec(commandArgs, environment, workingDir);
        StreamCopier t1 = new StreamCopier(new InputStreamReader(process.getInputStream()), outWriter);
        StreamCopier t2 = new StreamCopier(new InputStreamReader(process.getErrorStream()), errorWriter);
        t1.start();
        t2.start();
        int result = process.waitFor();
        t1.join();
        t2.join();
        return result;
    }

    private static class StreamCopier
    extends Thread {
        private final Reader input;
        private final Writer output;

        public StreamCopier(Reader input, Writer output) {
            this.input = input;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                char[] buffer = new char[512];
                int read = 0;
                while ((read = this.input.read(buffer, 0, 512)) != -1) {
                    this.output.write(buffer, 0, read);
                }
                this.input.close();
                this.output.flush();
            }
            catch (IOException e) {
                throw new StrategoException("IO Exception redirecting output from Process", e);
            }
        }
    }
}

