/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.StrategoExit;

public class StrategoErrorExit
extends StrategoExit {
    private static final long serialVersionUID = 1718563644820693442L;
    private final IStrategoTerm term;
    private final IStrategoList trace;

    public StrategoErrorExit(String message) {
        this(message, null, null, null);
    }

    public StrategoErrorExit(String message, IStrategoTerm term) {
        this(message, term, null, null);
    }

    public StrategoErrorExit(String message, IStrategoTerm term, Throwable cause) {
        this(message, term, null, cause);
    }

    public StrategoErrorExit(String message, IStrategoTerm term, IStrategoList trace) {
        this(message, term, trace, null);
    }

    public StrategoErrorExit(String message, IStrategoTerm term, IStrategoList trace, Throwable cause) {
        super(1, message, cause);
        this.term = term;
        this.trace = trace;
    }

    public IStrategoTerm getTerm() {
        return this.term;
    }

    @Override
    public String getLocalizedMessage() {
        StringBuilder sb = new StringBuilder(super.getMessage());
        IStrategoTerm term = this.getTerm();
        if (term != null) {
            sb.append("\n\t" + term);
        }
        if (this.trace != null) {
            int depth = this.trace.getSubtermCount();
            int i = 0;
            while (i < depth) {
                IStrategoTerm t = this.trace.getSubterm(depth - i - 1);
                sb.append("\n\t");
                sb.append(t.getTermType() == 5 ? Tools.asJavaString(t) : t);
                ++i;
            }
        }
        return sb.toString();
    }

    public IStrategoList getTrace() {
        return this.trace;
    }
}

