/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.util;

public class Assert {
    public static void assertEquals(String message, Object expected, Object actual) {
        if (!Assert.equalsRegardingNull(expected, actual)) {
            if (expected instanceof String && actual instanceof String) {
                String cleanMessage = message == null ? "" : message;
                Assert.fail("ComparisonFailure: " + cleanMessage + ", expected: " + expected + ", actual: " + actual);
            } else {
                Assert.failNotEquals(message, expected, actual);
            }
        }
    }

    private static boolean equalsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return Assert.isEquals(expected, actual);
    }

    private static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        Assert.fail(Assert.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !message.isEmpty()) {
            formatted = String.valueOf(message) + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return String.valueOf(formatted) + "expected: " + Assert.formatClassAndValue(expected, expectedString) + " but was: " + Assert.formatClassAndValue(actual, actualString);
        }
        return String.valueOf(formatted) + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return String.valueOf(className) + "<" + valueString + ">";
    }

    public static void assertEquals(long expected, long actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, long expected, long actual) {
        if (expected != actual) {
            Assert.failNotEquals(message, expected, actual);
        }
    }

    public static void fail(String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public static <T> void assertInstanceOf(T object, Class<? extends T> clazz) {
        if (clazz.isInstance(object)) {
            return;
        }
        Assert.fail(String.valueOf(object.getClass().getName()) + " is not instance of " + clazz.getName());
    }
}

