/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.tokens.treeshaped;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mb.jsglr.shared.IToken;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr2.imploder.StrategoTermTokenizer;
import org.spoofax.jsglr2.imploder.TreeImploder;
import org.spoofax.jsglr2.imploder.treefactory.TokenizedTermTreeFactory;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.tokens.treeshaped.TreeToken;
import org.spoofax.jsglr2.tokens.treeshaped.TreeTokens;

public class TokenTree {
    final IStrategoTerm tree;
    final TreeToken token;
    TokenTree parent;
    final List<TokenTree> children;
    final List<TokenTree> nonNullChildren;
    final Position positionRange;
    final int size;
    final TreeToken leftToken;
    final TreeToken rightToken;
    final Collection<IToken> leftTokens;
    final Collection<IToken> rightTokens;
    final boolean isAmbiguous;

    protected TokenTree(TreeImploder.SubTree<IStrategoTerm> tree, TreeToken treeToken) {
        this.tree = tree == null ? null : (IStrategoTerm)tree.tree;
        this.rightToken = this.token = treeToken;
        this.leftToken = this.token;
        if (treeToken == null) {
            this.rightTokens = null;
            this.leftTokens = null;
        } else {
            this.rightTokens = Collections.singleton(treeToken);
            this.leftTokens = this.rightTokens;
        }
        this.nonNullChildren = Collections.emptyList();
        this.children = this.nonNullChildren;
        this.positionRange = treeToken == null ? TreeTokens.EMPTY_RANGE : treeToken.positionRange;
        this.size = treeToken == null ? 0 : 1;
        this.isAmbiguous = false;
        if (treeToken != null) {
            treeToken.tree = this;
        }
        this.configure(tree);
    }

    protected TokenTree(TreeImploder.SubTree<IStrategoTerm> tree, List<TokenTree> children, TreeToken leftToken, TreeToken rightToken, Position positionRange) {
        this.tree = tree == null ? null : (IStrategoTerm)tree.tree;
        this.token = null;
        this.children = children;
        this.nonNullChildren = children.stream().filter(c -> c.leftToken != null).collect(Collectors.toList());
        this.leftToken = leftToken;
        this.rightToken = rightToken;
        this.positionRange = positionRange;
        this.isAmbiguous = tree != null && tree.isAmbiguous;
        int size = 0;
        for (TokenTree child : children) {
            size += child.size;
        }
        this.size = size;
        if (this.isAmbiguous) {
            this.leftTokens = this.nonNullChildren.stream().flatMap(c -> c.leftTokens.stream()).collect(Collectors.toList());
            this.rightTokens = this.nonNullChildren.stream().flatMap(c -> c.rightTokens.stream()).collect(Collectors.toList());
        } else {
            Collection<IToken> leftTokens = null;
            Collection<IToken> rightTokens = null;
            for (TokenTree child : children) {
                if (leftTokens == null) {
                    leftTokens = child.leftTokens;
                }
                if (child.rightTokens == null) continue;
                rightTokens = child.rightTokens;
            }
            this.leftTokens = leftTokens;
            this.rightTokens = rightTokens;
        }
        this.configure(tree);
    }

    private void configure(TreeImploder.SubTree<IStrategoTerm> tree) {
        assert (this.leftToken != null ^ this.rightToken == null) : "Both tokens should be either null, or not null";
        if (tree != null && tree.tree != null) {
            assert (this.leftToken != null && this.rightToken != null) : "All AST nodes should have tokens, even if it's empty";
            if (tree.isInjection) {
                TokenizedTermTreeFactory.configureInjection(tree.production.lhs(), (IStrategoTerm)tree.tree, tree.production.isBracket());
            } else {
                String sort = tree.production == null ? null : tree.production.sort();
                StrategoTermTokenizer.configureStatic((IStrategoTerm)tree.tree, sort, this.leftToken, this.rightToken);
            }
        }
    }
}

