/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.stack.hybrid;

import java.util.ArrayList;
import java.util.Collections;
import org.metaborg.parsetable.states.IState;
import org.spoofax.jsglr2.stack.AbstractStackNode;
import org.spoofax.jsglr2.stack.StackLink;
import org.spoofax.jsglr2.util.iterators.SingleElementWithListIterable;

public class HybridStackNode<ParseForest>
extends AbstractStackNode<ParseForest, HybridStackNode<ParseForest>> {
    private StackLink<ParseForest, HybridStackNode<ParseForest>> firstLink;
    private ArrayList<StackLink<ParseForest, HybridStackNode<ParseForest>>> otherLinks;

    public HybridStackNode(IState state) {
        super(state);
    }

    @Override
    public Iterable<StackLink<ParseForest, HybridStackNode<ParseForest>>> getLinks() {
        if (this.otherLinks == null) {
            return Collections.singleton(this.firstLink);
        }
        return SingleElementWithListIterable.of(this.firstLink, this.otherLinks);
    }

    @Override
    public StackLink<ParseForest, HybridStackNode<ParseForest>> addLink(StackLink<ParseForest, HybridStackNode<ParseForest>> link) {
        if (this.firstLink == null) {
            this.firstLink = link;
        } else {
            if (this.otherLinks == null) {
                this.otherLinks = new ArrayList();
            }
            this.otherLinks.add(link);
        }
        return link;
    }

    @Override
    public boolean allLinksRejected() {
        if (this.firstLink == null || !this.firstLink.isRejected()) {
            return false;
        }
        if (this.otherLinks == null) {
            return true;
        }
        for (StackLink<ParseForest, HybridStackNode<ParseForest>> link : this.otherLinks) {
            if (link.isRejected()) continue;
            return false;
        }
        return true;
    }
}

