/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.stack.collections;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.metaborg.parsetable.states.IState;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.observing.ParserObserving;
import org.spoofax.jsglr2.stack.IStackNode;
import org.spoofax.jsglr2.stack.collections.IActiveStacks;
import org.spoofax.jsglr2.stack.collections.IForActorStacks;

public class ActiveStacksLinkedHashMap<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>, StackNode extends IStackNode, ParseState extends AbstractParseState<?, StackNode>>
implements IActiveStacks<StackNode> {
    private ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing;
    protected Map<Integer, Linked<StackNode>> activeStacks;
    private Linked<StackNode> last;

    public ActiveStacksLinkedHashMap(ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing) {
        this.observing = observing;
        this.activeStacks = new HashMap<Integer, Linked<StackNode>>();
        this.last = null;
    }

    @Override
    public void add(StackNode stack) {
        this.observing.notify(observer -> observer.addActiveStack(stack));
        Linked<StackNode> linkedStackNode = new Linked<StackNode>(stack, this.last);
        this.activeStacks.put(stack.state().id(), linkedStackNode);
        this.last = linkedStackNode;
    }

    @Override
    public boolean isSingle() {
        return this.last != null && this.last.prev == null;
    }

    @Override
    public StackNode getSingle() {
        return (StackNode)((IStackNode)this.last.stack);
    }

    @Override
    public boolean isEmpty() {
        return this.last == null;
    }

    @Override
    public boolean isMultiple() {
        return this.activeStacks.size() > 1;
    }

    @Override
    public StackNode findWithState(IState state) {
        this.observing.notify(observer -> observer.findActiveStackWithState(state));
        Linked<StackNode> linkedStackNode = this.activeStacks.get(state.id());
        return (StackNode)(linkedStackNode != null ? (IStackNode)linkedStackNode.stack : null);
    }

    @Override
    public Iterable<StackNode> forLimitedReductions(final IForActorStacks<StackNode> forActorStacks) {
        return () -> new Iterator<StackNode>(){
            Linked<StackNode> current;
            {
                this.current = ActiveStacksLinkedHashMap.this.last;
            }

            @Override
            public boolean hasNext() {
                while (this.current != null && (((IStackNode)this.current.stack).allLinksRejected() || forActorStacks.contains((IStackNode)this.current.stack))) {
                    this.current = this.current.prev;
                }
                return this.current != null;
            }

            @Override
            public StackNode next() {
                IStackNode currentStack = (IStackNode)this.current.stack;
                this.current = this.current.prev;
                return currentStack;
            }
        };
    }

    @Override
    public void addAllTo(IForActorStacks<StackNode> other) {
        Linked<Object> linkedState = this.last;
        while (linkedState != null) {
            other.add((IStackNode)linkedState.stack);
            linkedState = linkedState.prev;
        }
    }

    @Override
    public void clear() {
        this.activeStacks.clear();
        this.last = null;
    }

    @Override
    public Iterator<StackNode> iterator() {
        return new Iterator<StackNode>(){
            Linked<StackNode> current;
            {
                this.current = ActiveStacksLinkedHashMap.this.last;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public StackNode next() {
                IStackNode currentStack = (IStackNode)this.current.stack;
                this.current = this.current.prev;
                return currentStack;
            }
        };
    }

    private static class Linked<T> {
        T stack;
        Linked<T> prev;

        Linked(T stack, Linked<T> prev) {
            this.stack = stack;
            this.prev = prev;
        }
    }
}

