/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.imploder;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Stack;
import mb.jsglr.shared.IToken;
import org.spoofax.jsglr2.imploder.TreeImploder;
import org.spoofax.jsglr2.imploder.TreeTokenizer;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.tokens.Tokens;

public abstract class IterativeTreeTokenizer<Tree>
extends TreeTokenizer<Tree> {
    @Override
    public void tokenize(Tokens tokens, TreeImploder.SubTree<Tree> rootTree) {
        tokens.makeStartToken();
        this.tokenTreeBinding(tokens.startToken(), rootTree.tree);
        Stack inputStack = new Stack();
        Stack<Position> pivotPositionStack = new Stack<Position>();
        Stack<Position> startPositionStack = new Stack<Position>();
        Stack outputStack = new Stack();
        inputStack.add(new LinkedList<TreeImploder.SubTree<Tree>>(Collections.singletonList(rootTree)));
        pivotPositionStack.add(Position.START_POSITION);
        startPositionStack.add(Position.START_POSITION);
        outputStack.add(new LinkedList());
        while (true) {
            TreeImploder.SubTree tree;
            LinkedList currentIn = (LinkedList)inputStack.peek();
            Position currentPos = (Position)pivotPositionStack.peek();
            Position currentStart = (Position)startPositionStack.peek();
            LinkedList currentOut = (LinkedList)outputStack.peek();
            if (currentIn.isEmpty()) {
                inputStack.pop();
                if (inputStack.isEmpty()) break;
                pivotPositionStack.pop();
                startPositionStack.pop();
                outputStack.pop();
                tree = (TreeImploder.SubTree)((LinkedList)inputStack.peek()).removeFirst();
                IToken leftToken = null;
                IToken rightToken = null;
                Position pivotPosition = currentPos;
                for (TreeTokenizer.SubTree subTree : currentOut) {
                    if (subTree.tree == null) {
                        if (subTree.leftToken != null) {
                            this.tokenTreeBinding(subTree.leftToken, tree.tree);
                        }
                        if (subTree.rightToken != null) {
                            this.tokenTreeBinding(subTree.rightToken, tree.tree);
                        }
                    }
                    if (leftToken == null) {
                        leftToken = subTree.leftToken;
                    }
                    if (subTree.rightToken != null) {
                        rightToken = subTree.rightToken;
                    }
                    pivotPosition = subTree.endPosition;
                }
                if (leftToken == null) {
                    assert (rightToken == null);
                    leftToken = rightToken = tokens.makeToken(currentStart, pivotPosition, tree.production);
                    this.tokenTreeBinding(leftToken, tree.tree);
                }
                if (inputStack.size() > 1 && !((TreeImploder.SubTree)((LinkedList)inputStack.get((int)(inputStack.size() - 2))).peek()).isAmbiguous) {
                    pivotPositionStack.pop();
                    pivotPositionStack.push(pivotPosition);
                }
                ((LinkedList)outputStack.peek()).add(new TreeTokenizer.SubTree(this, tree, leftToken, rightToken, pivotPosition));
                continue;
            }
            tree = (TreeImploder.SubTree)currentIn.getFirst();
            if (tree.production != null && !tree.production.isContextFree() || tree.isCharacterTerminal) {
                if (tree.width > 0 || tree.tree != null) {
                    Position endPosition = currentPos.step(tokens.getInput(), tree.width);
                    IToken token = tokens.makeToken(currentPos, endPosition, tree.production);
                    this.tokenTreeBinding(token, tree.tree);
                    currentOut.add(new TreeTokenizer.SubTree(this, tree, token, token, endPosition));
                    pivotPositionStack.pop();
                    pivotPositionStack.push(endPosition);
                } else {
                    currentOut.add(new TreeTokenizer.SubTree(this, tree, null, null, currentPos));
                }
                currentIn.removeFirst();
                continue;
            }
            inputStack.add(new LinkedList(tree.children));
            pivotPositionStack.add(currentPos);
            startPositionStack.add(currentPos);
            outputStack.add(new LinkedList());
        }
        TreeTokenizer.SubTree res = (TreeTokenizer.SubTree)((LinkedList)outputStack.pop()).getFirst();
        tokens.makeEndToken(res.endPosition);
        this.tokenTreeBinding(tokens.endToken(), res.tree);
    }
}

