/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import java.util.List;
import org.spoofax.interpreter.core.BindingInfo;
import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Pair;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.stratego.Hook;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class GuardedLChoice
extends Strategy {
    private Pair<Strategy, Strategy>[] children;

    public GuardedLChoice(Pair<Strategy, Strategy>[] strs) {
        this.children = strs;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        GuardedLChoice.debug("GuardedLChoice.eval() - ", env.current());
        return this.eval(env, 0);
    }

    protected Strategy eval(IContext env, final int n) throws InterpreterException {
        if (n == this.children.length - 1) {
            Strategy s = (Strategy)this.children[n].first;
            s.getHook().push(this.getHook().pop());
            return s;
        }
        final List<BindingInfo> bi = env.getVarScope().saveUnboundVars();
        final IStrategoTerm oldCurrent = env.current();
        final Strategy second = (Strategy)this.children[n].second;
        Strategy first = (Strategy)this.children[n].first;
        first.getHook().push(new Hook(){

            @Override
            public IConstruct onSuccess(IContext env) {
                second.getHook().push(GuardedLChoice.this.getHook().pop());
                return second;
            }

            @Override
            public IConstruct onFailure(IContext env) throws InterpreterException {
                env.setCurrent(oldCurrent);
                VarScope.backtrackUnboundVars(bi);
                final Hook h = GuardedLChoice.this.getHook().pop();
                GuardedLChoice.this.getHook().push(new Hook(){

                    @Override
                    public IConstruct onSuccess(IContext env) throws InterpreterException {
                        VarScope.restoreUnboundVars(bi);
                        return h.onSuccess(env);
                    }

                    @Override
                    public IConstruct onFailure(IContext env) throws InterpreterException {
                        return h.onFailure(env);
                    }
                });
                return GuardedLChoice.this.eval(env, n + 1);
            }
        });
        return first;
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.first("GuardedLChoice(");
        sf.bump(15);
        sf.append("  ");
        sf.bump(2);
        sf.unbump(2);
        sf.append(", ");
        sf.bump(2);
        sf.unbump(2);
        sf.append(", ");
        sf.bump(2);
        sf.unbump(2);
        sf.unbump(15);
        sf.line(")");
    }
}

