/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.ssl;

import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class SSL_access
extends AbstractPrimitive {
    private static final int R_OK = 4;
    private static final int W_OK = 2;
    private static final int X_OK = 1;
    private static final int F_OK = 0;

    protected SSL_access() {
        super("SSL_access", 0, 2);
    }

    @Override
    public boolean call(IContext env, Strategy[] sargs, IStrategoTerm[] targs) throws InterpreterException {
        if (!TermUtils.isString(targs[0])) {
            return false;
        }
        if (!TermUtils.isList(targs[1])) {
            return false;
        }
        SSLLibrary op = (SSLLibrary)env.getOperatorRegistry("SSL");
        IOAgent agent = op.getIOAgent();
        String path = TermUtils.toJavaString(targs[0]);
        int permissions = this.permissions_from_term((IStrategoList)targs[1]);
        if ((permissions & 4) != 0) {
            if (!agent.readable(path)) {
                return false;
            }
        } else if ((permissions & 2) != 0) {
            if (!agent.writable(path)) {
                return false;
            }
        } else {
            if ((permissions & 1) != 0) {
                return false;
            }
            if (permissions == 0 && !agent.exists(path)) {
                return false;
            }
        }
        env.setCurrent(targs[0]);
        return true;
    }

    private int permissions_from_term(IStrategoList perms) {
        int res = 0;
        int i = 0;
        while (i < perms.size()) {
            IStrategoAppl t = TermUtils.toApplAt(perms, i);
            if (TermUtils.isAppl((IStrategoTerm)t, "W_OK")) {
                res |= 2;
            } else if (TermUtils.isAppl((IStrategoTerm)t, "R_OK")) {
                res |= 4;
            } else if (TermUtils.isAppl((IStrategoTerm)t, "X_OK")) {
                res |= 1;
            } else if (TermUtils.isAppl((IStrategoTerm)t, "F_OK")) {
                res |= 0;
            } else {
                System.err.println("*** ERROR: not an access mode: " + t);
            }
            ++i;
        }
        return res;
    }
}

