/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.origin;

import java.util.ArrayList;
import mb.jsglr.shared.IToken;
import mb.jsglr.shared.ITokenizer;
import mb.jsglr.shared.ImploderAttachment;
import mb.jsglr.shared.Token;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.jsglr.origin.AbstractOriginPrimitive;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.attachments.OriginAttachment;

public class OriginTokenExpandPrimitive
extends AbstractOriginPrimitive {
    public OriginTokenExpandPrimitive() {
        super("SSL_EXT_origin_token_expand");
    }

    @Override
    public IStrategoTerm call(IContext env, IStrategoTerm origin) {
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(origin);
        int startIndex = ImploderAttachment.getLeftToken(origin).getIndex();
        int endIndex = ImploderAttachment.getRightToken(origin).getIndex();
        ArrayList<IStrategoTerm> resultTerms = new ArrayList<IStrategoTerm>();
        int i = startIndex;
        while (i <= endIndex) {
            Token tok = tokenizer.getTokenAt(i);
            if (tok.getKind() != IToken.Kind.TK_EOF) {
                IStrategoTerm containingSubTerm = this.getContainingSubTerm(i, origin);
                if (containingSubTerm != null) {
                    resultTerms.add(containingSubTerm);
                    i = ImploderAttachment.getRightToken(containingSubTerm).getIndex();
                } else {
                    IStrategoString tokenTerm = env.getFactory().makeString(tokenizer.getTokenAt(i).toString());
                    OriginAttachment.setOrigin(tokenTerm, origin);
                    resultTerms.add(tokenTerm);
                }
            }
            ++i;
        }
        return env.getFactory().makeList(resultTerms);
    }

    private boolean inTokenRange(int tokenIndex, IStrategoTerm origin) {
        int startIndex = ImploderAttachment.getLeftToken(origin).getIndex();
        int endIndex = ImploderAttachment.getRightToken(origin).getIndex();
        return startIndex <= tokenIndex && tokenIndex <= endIndex;
    }

    private IStrategoTerm getContainingSubTerm(int tokenIndex, IStrategoTerm origin) {
        IStrategoTerm[] subTerms = origin.getAllSubterms();
        int i = 0;
        while (i < subTerms.length) {
            if (this.inTokenRange(tokenIndex, subTerms[i])) {
                return subTerms[i];
            }
            ++i;
        }
        return null;
    }
}

