/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.index;

import org.metaborg.util.collection.MultiSet;
import org.spoofax.interpreter.library.index.IndexEntry;
import org.spoofax.interpreter.library.index.IndexEntryFactory;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;

public class IndexCollector {
    private final ITermFactory termFactory;
    private final IndexEntryFactory entryFactory;
    private MultiSet.Transient<IndexEntry> addedEntries = MultiSet.Transient.of();
    private MultiSet.Transient<IndexEntry> removedEntries = MultiSet.Transient.of();
    private MultiSet.Transient<IndexEntry> oldEntries = MultiSet.Transient.of();
    private IStrategoTerm sourceInCollection = null;

    public IndexCollector(ITermFactory termFactory, IndexEntryFactory entryFactory) {
        this.termFactory = termFactory;
        this.entryFactory = entryFactory;
    }

    public void start(IStrategoTerm source, Iterable<IndexEntry> currentEntries) {
        this.reset();
        currentEntries.forEach(this.removedEntries::add);
        currentEntries.forEach(this.oldEntries::add);
        this.sourceInCollection = source;
    }

    public IStrategoTuple stop() {
        this.sourceInCollection = null;
        this.addedEntries.removeAll(this.oldEntries);
        return this.termFactory.makeTuple(this.entryFactory.toKeyTerms(this.removedEntries), this.entryFactory.toKeyTerms(this.addedEntries));
    }

    public IndexEntry add(IStrategoTerm key, IStrategoTerm value) {
        return this.add(this.entryFactory.create(key, value, this.sourceInCollection));
    }

    public IndexEntry add(IStrategoTerm key) {
        return this.add(this.entryFactory.create(key, this.sourceInCollection));
    }

    public IndexEntry add(IndexEntry entry) {
        assert (entry.source.match(this.sourceInCollection));
        this.addedEntries.add(entry);
        this.removedEntries.remove(entry);
        return entry;
    }

    public Iterable<IndexEntry> getAddedEntries() {
        return this.addedEntries;
    }

    public boolean inCollection() {
        return this.sourceInCollection != null;
    }

    public void recover() {
        this.reset();
    }

    public void reset() {
        this.addedEntries = MultiSet.Transient.of();
        this.removedEntries = MultiSet.Transient.of();
        this.oldEntries = MultiSet.Transient.of();
        this.sourceInCollection = null;
    }
}

