/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import org.spoofax.interpreter.library.IOAgent;

public class LoggingIOAgent
extends IOAgent {
    private final LoggingOutputStream stdoutLog = new LoggingOutputStream(System.out);
    private final LoggingOutputStream stderrLog = new LoggingOutputStream(System.err);
    private final PrintStream stdout = new PrintStream(this.stdoutLog, true);
    private final PrintStream stderr = new PrintStream(this.stderrLog, true);
    private final OutputStreamWriter stdoutWriter = new OutputStreamWriter(this.stdoutLog);
    private final OutputStreamWriter stderrWriter = new OutputStreamWriter(this.stderrLog);
    final ByteArrayOutputStream bytes = new ByteArrayOutputStream();

    public String getLog() {
        return this.bytes.toString();
    }

    public void clearLog() {
        this.bytes.reset();
    }

    @Override
    public OutputStream internalGetOutputStream(int fd) {
        switch (fd) {
            case 1: {
                this.stdoutLog.stream = System.out;
                return this.stdout;
            }
            case 2: {
                this.stderrLog.stream = System.err;
                return this.stderr;
            }
        }
        return super.internalGetOutputStream(fd);
    }

    @Override
    public Writer getWriter(int fd) {
        switch (fd) {
            case 1: {
                this.stdoutLog.stream = System.out;
                return this.stdoutWriter;
            }
            case 2: {
                this.stderrLog.stream = System.err;
                return this.stderrWriter;
            }
        }
        return super.getWriter(fd);
    }

    private class LoggingOutputStream
    extends OutputStream {
        OutputStream stream;

        public LoggingOutputStream(OutputStream stream) {
            this.stream = stream;
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
            LoggingIOAgent.this.bytes.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.stream.write(b);
            LoggingIOAgent.this.bytes.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
            LoggingIOAgent.this.bytes.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
        }

        @Override
        public void close() throws IOException {
            this.stream.flush();
        }
    }
}

