/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.iterators;

import java.util.Iterator;

public class PeekingIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private E peekedElement = null;

    public PeekingIterator(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.peekedElement != null || this.iterator.hasNext();
    }

    @Override
    public E next() {
        if (this.peekedElement == null) {
            return this.iterator.next();
        }
        E result = this.peekedElement;
        this.peekedElement = null;
        return result;
    }

    @Override
    public void remove() {
        if (this.peekedElement != null) {
            throw new IllegalStateException("Cannot remove after peeking.");
        }
        this.iterator.remove();
    }

    public E peek() {
        if (this.peekedElement == null) {
            this.peekedElement = this.iterator.next();
        }
        return this.peekedElement;
    }
}

