/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

public interface ImmutableCollection<E>
extends Collection<E> {
    @Override
    public Iterator<E> iterator();

    @Override
    public int size();

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public boolean contains(Object o) {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(o, it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    default public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    default public <T> T[] toArray(T[] a) {
        int size = this.size();
        Object[] result = a.length < size ? (Object[])Array.newInstance(a.getClass().getComponentType(), size) : a;
        int i = 0;
        for (E e : this) {
            result[i] = e;
            ++i;
        }
        return result;
    }

    @Override
    default public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return c.stream().allMatch(this::contains);
    }

    @Override
    default public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void clear() {
        throw new UnsupportedOperationException();
    }
}

