/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.metaborg.util.collection.IRelation2;
import org.metaborg.util.collection.Sets;

public abstract class HashTrieRelation2<K, V>
implements IRelation2<K, V> {
    protected HashTrieRelation2() {
    }

    protected abstract SetMultimap<K, V> fwd();

    protected abstract SetMultimap<V, K> bwd();

    @Override
    public boolean containsKey(K key) {
        return this.fwd().containsKey(key);
    }

    @Override
    public boolean containsEntry(K key, V value) {
        return this.fwd().containsEntry(key, value);
    }

    @Override
    public boolean containsValue(V value) {
        return this.bwd().containsKey(value);
    }

    @Override
    public Set<K> keySet() {
        return this.fwd().keySet();
    }

    @Override
    public Set<V> valueSet() {
        return this.bwd().keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.fwd().entrySet();
    }

    @Override
    public Set.Immutable<V> get(K key) {
        return this.fwd().get(key);
    }

    @Override
    public int size() {
        return this.fwd().size();
    }

    @Override
    public boolean isEmpty() {
        return this.fwd().isEmpty();
    }

    public String toString() {
        return this.fwd().toString();
    }

    public static <K, V> IRelation2<K, V> union(IRelation2<K, V> rel1, IRelation2<K, V> rel2) {
        return new Union(rel1, rel2);
    }

    public static class Immutable<K, V>
    extends HashTrieRelation2<K, V>
    implements IRelation2.Immutable<K, V>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final SetMultimap.Immutable<K, V> fwd;
        private final SetMultimap.Immutable<V, K> bwd;

        Immutable(SetMultimap.Immutable<K, V> fwd, SetMultimap.Immutable<V, K> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        protected SetMultimap<K, V> fwd() {
            return this.fwd;
        }

        @Override
        protected SetMultimap<V, K> bwd() {
            return this.bwd;
        }

        @Override
        public IRelation2.Immutable<V, K> inverse() {
            return new Immutable<V, K>(this.bwd, this.fwd);
        }

        @Override
        public IRelation2.Immutable<K, V> putAll(IRelation2<K, V> other) {
            IRelation2.Transient that = this.melt();
            that.putAll(other);
            return that.freeze();
        }

        @Override
        public Transient<K, V> melt() {
            return new Transient(this.fwd.asTransient(), this.bwd.asTransient());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fwd.hashCode();
            result = 31 * result + this.bwd.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            if (!this.fwd.equals(other.fwd)) {
                return false;
            }
            return this.bwd.equals(other.bwd);
        }

        public static <K, V> Immutable<K, V> of() {
            return new Immutable<K, V>(SetMultimap.Immutable.of(), SetMultimap.Immutable.of());
        }
    }

    public static class Transient<K, V>
    extends HashTrieRelation2<K, V>
    implements IRelation2.Transient<K, V> {
        private final SetMultimap.Transient<K, V> fwd;
        private final SetMultimap.Transient<V, K> bwd;

        Transient(SetMultimap.Transient<K, V> fwd, SetMultimap.Transient<V, K> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        protected SetMultimap<K, V> fwd() {
            return this.fwd;
        }

        @Override
        protected SetMultimap<V, K> bwd() {
            return this.bwd;
        }

        @Override
        public boolean put(K key, V value) {
            if (this.fwd.__insert(key, value)) {
                this.bwd.__insert(value, key);
                return true;
            }
            return false;
        }

        @Override
        public boolean putAll(K key, Iterable<? extends V> values) {
            boolean change = false;
            for (V value : values) {
                change |= this.put(key, value);
            }
            return change;
        }

        @Override
        public boolean putAll(IRelation2<K, V> other) {
            return other.stream().reduce(false, (change, klv) -> Boolean.logicalOr(change, this.put(klv._1(), klv._2())), Boolean::logicalOr);
        }

        @Override
        public Set.Immutable<V> removeKey(K key) {
            Set.Immutable values = this.fwd.get(key);
            this.fwd.__remove(key);
            for (Object value : values) {
                this.bwd.__remove(value, key);
            }
            return values;
        }

        @Override
        public Set.Immutable<K> removeValue(V value) {
            Set.Immutable keys = this.bwd.get(value);
            this.bwd.__remove(value);
            for (Object key : keys) {
                this.fwd.__remove(key, value);
            }
            return keys;
        }

        @Override
        public boolean removeEntry(K key, V value) {
            if (this.fwd.__remove(key, value)) {
                this.bwd.__remove(value, key);
                return true;
            }
            return false;
        }

        @Override
        public IRelation2.Transient<V, K> inverse() {
            return new Transient<V, K>(this.bwd, this.fwd);
        }

        @Override
        public Immutable<K, V> freeze() {
            return new Immutable(this.fwd.freeze(), this.bwd.freeze());
        }

        public static <K, V> Transient<K, V> of() {
            return new Transient<K, V>(SetMultimap.Transient.of(), SetMultimap.Transient.of());
        }
    }

    private static class Union<K, V>
    implements IRelation2<K, V> {
        private final IRelation2<K, V> rel1;
        private final IRelation2<K, V> rel2;

        private Union(IRelation2<K, V> rel1, IRelation2<K, V> rel2) {
            this.rel1 = rel1;
            this.rel2 = rel2;
        }

        @Override
        public IRelation2<V, K> inverse() {
            return new Union<V, K>(this.rel1.inverse(), this.rel2.inverse());
        }

        @Override
        public boolean containsKey(K key) {
            return this.rel1.containsKey(key) || this.rel2.containsKey(key);
        }

        @Override
        public boolean containsEntry(K key, V value) {
            return this.rel1.containsEntry(key, value) || this.rel2.containsEntry(key, value);
        }

        @Override
        public boolean containsValue(V value) {
            return this.rel1.containsValue(value) || this.rel2.containsValue(value);
        }

        @Override
        public int size() {
            return this.rel1.size() + this.rel2.size();
        }

        @Override
        public boolean isEmpty() {
            return this.rel1.isEmpty() && this.rel2.isEmpty();
        }

        @Override
        public Set<V> get(K key) {
            return Sets.union(this.rel1.get(key), this.rel2.get(key));
        }

        @Override
        public Set<K> keySet() {
            return Sets.union(this.rel1.keySet(), this.rel2.keySet());
        }

        @Override
        public Set<V> valueSet() {
            return Sets.union(this.rel1.valueSet(), this.rel2.valueSet());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Sets.union(this.rel1.entrySet(), this.rel2.entrySet());
        }
    }
}

