/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.functions.Predicate1;

public final class CapsuleUtil {
    private static final Set.Immutable EMPTY_SET = Set.Immutable.of();
    private static final Map.Immutable EMPTY_MAP = Map.Immutable.of();

    private CapsuleUtil() {
    }

    public static <K1, V1, K2, V2> Map.Immutable<K2, V2> mapEntries(io.usethesource.capsule.Map<K1, V1> map, BiFunction<K1, V1, Map.Entry<K2, V2>> f) {
        Map.Transient newMap = Map.Transient.of();
        map.forEach((k, v) -> {
            Map.Entry newEntry = (Map.Entry)f.apply(k, v);
            newMap.__put(newEntry.getKey(), newEntry.getValue());
        });
        return newMap.freeze();
    }

    public static <K, V> void updateValues(Map.Transient<K, V> map, Function2<K, V, V> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            V val = mapper.apply(key, entry.getValue());
            if (val == null) continue;
            map.__put(key, val);
        }
    }

    public static <K, V> void updateValuesOrRemove(Map.Transient<K, V> map, Function2<K, V, V> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            V val = mapper.apply(key, entry.getValue());
            if (val != null) {
                map.__put(key, val);
                continue;
            }
            map.__remove(key);
        }
    }

    public static <K, V> void updateKeys(Map.Transient<K, V> map, Function2<K, V, K> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            K newKey = mapper.apply(key, entry.getValue());
            if (newKey == null) continue;
            map.__remove(key);
            map.__put(newKey, entry.getValue());
        }
    }

    public static <K, V> void filter(Map.Transient<K, V> map, Predicate1<K> filter) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            if (filter.test(key)) continue;
            map.__remove(key);
        }
    }

    public static <K, V> void updateKeysOrRemove(Map.Transient<K, V> map, Function2<K, V, K> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            K newKey = mapper.apply(key, entry.getValue());
            map.__remove(key);
            if (newKey == null) continue;
            map.__put(newKey, entry.getValue());
        }
    }

    public static <K, V> void update(Set.Transient<V> set, Function1<V, V> mapper) {
        for (Object val : set) {
            V newVal = mapper.apply(val);
            if (newVal == null) continue;
            set.__remove(val);
            set.__insert(newVal);
        }
    }

    public static <K, V> void updateOrRemove(Set.Transient<V> set, Function1<V, V> mapper) {
        for (Object val : set) {
            V newVal = mapper.apply(val);
            set.__remove(val);
            if (newVal == null) continue;
            set.__insert(newVal);
        }
    }

    public static <V> Set.Immutable<V> toSet(Iterable<? extends V> values) {
        if (values instanceof Set.Immutable) {
            return (Set.Immutable)values;
        }
        Set.Transient set = CapsuleUtil.transientSet();
        for (V v : values) {
            set.__insert(v);
        }
        return set.freeze();
    }

    public static <V> Set.Immutable<V> toSet(V ... values) {
        Set.Transient set = CapsuleUtil.transientSet();
        V[] VArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            V v = VArray[n2];
            set.__insert(v);
            ++n2;
        }
        return set.freeze();
    }

    public static <K, V> Map.Immutable<K, V> toMap(Map<? extends K, ? extends V> map) {
        if (map instanceof Map.Immutable) {
            return (Map.Immutable)map;
        }
        return CapsuleUtil.immutableMap().__putAll(map);
    }

    public static <K, V1, V2> Map.Immutable<K, V2> toMap(Map<? extends K, V1> map, Function1<V1, V2> valueMapper) {
        Map.Transient result = Map.Transient.of();
        map.forEach((k, v1) -> result.__put(k, valueMapper.apply(v1)));
        return result.freeze();
    }

    public static <K, V> Map.Immutable<K, V> toMap(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Map.Transient<K, V> map = CapsuleUtil.transientMap();
        for (Map.Entry<K, V> e : entries) {
            map.__put(e.getKey(), e.getValue());
        }
        return map.freeze();
    }

    public static <K, V> SetMultimap.Immutable<K, V> toSetMultimap(SetMultimap<? extends K, ? extends V> map) {
        if (map instanceof SetMultimap.Immutable) {
            return (SetMultimap.Immutable)map;
        }
        SetMultimap.Transient multimap = SetMultimap.Transient.of();
        for (Map.Entry e : map.entrySet()) {
            multimap.__insert(e.getKey(), e.getValue());
        }
        return multimap.freeze();
    }

    public static <K> Set.Immutable<K> immutableSet() {
        return EMPTY_SET;
    }

    public static <K> Set.Immutable<K> immutableSet(K value) {
        return EMPTY_SET.__insert(value);
    }

    public static <K> Set.Immutable<K> immutableSet(K value1, K value2) {
        return EMPTY_SET.__insert(value1).__insert(value2);
    }

    public static <K> Set.Transient<K> transientSet() {
        return EMPTY_SET.asTransient();
    }

    public static <K> Set.Transient<K> transientSet(K value1) {
        return EMPTY_SET.__insert(value1).asTransient();
    }

    public static <K, V> Map.Immutable<K, V> immutableMap() {
        return EMPTY_MAP;
    }

    public static <K, V> Map.Transient<K, V> transientMap() {
        return EMPTY_MAP.asTransient();
    }

    public static <K, V> Set.Immutable<V> removeAll(SetMultimap.Transient<K, V> map, K key) {
        Set.Immutable vs = map.get(key);
        map.__remove(key);
        return vs;
    }

    public static <K, V> void putAll(Map.Transient<K, V> map, K key, Collection<V> values) {
        values.forEach(value -> {
            Object object2 = map.__put(key, value);
        });
    }

    public static <K, V> void addAll(Set.Transient<K> map, Collection<K> keys) {
        keys.forEach(key -> {
            boolean bl = map.__insert(key);
        });
    }

    public static <K, V> void putAll(SetMultimap.Transient<K, V> map, K key, Collection<V> values) {
        values.forEach(value -> {
            boolean bl = map.__insert(key, value);
        });
    }

    public static <K, V> void putAll(SetMultimap.Transient<K, V> map, SetMultimap.Transient<K, V> toAdd) {
        toAdd.entrySet().forEach(e -> {
            boolean bl = map.__insert(e.getKey(), e.getValue());
        });
    }

    public static <T, K, V> Map.Immutable<K, V> collectToMap(Stream<T> stream, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        Map.Transient result = CapsuleUtil.transientMap();
        stream.forEach(t -> {
            Object newValue;
            Object key = keyFunction.apply(t);
            Object value = valueFunction.apply(t);
            Object oldValue = result.get(key);
            Object r = newValue = oldValue == null ? value : mergeFunction.apply(oldValue, value);
            if (newValue == null) {
                result.__remove(key);
            } else {
                result.__put(key, newValue);
            }
        });
        return result.freeze();
    }

    public static <T, K, V> Map.Immutable<K, V> collectToMap(Stream<T> stream, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return CapsuleUtil.collectToMap(stream, keyFunction, valueFunction, (u, v) -> {
            throw new IllegalStateException("Duplicate key" + u);
        });
    }

    public static final class MapBuilder<K, V> {
        public final Map.Transient<K, V> map = CapsuleUtil.transientMap();

        public MapBuilder<K, V> put(K key, V value) {
            this.map.__put(key, value);
            return this;
        }

        public Map.Immutable<K, V> build() {
            return this.map.freeze();
        }
    }

    public static final class SetBuilder<K> {
        public final Set.Transient<K> set = CapsuleUtil.transientSet();

        public SetBuilder<K> add(K key) {
            this.set.__insert(key);
            return this;
        }

        public Set.Immutable<K> build() {
            return this.set.freeze();
        }
    }
}

