/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.metaborg.util.collection.BiSetMultimap;
import org.metaborg.util.stream.Collectors2;

public class BiLinkedHashMultimap<K, V>
implements BiSetMultimap<K, V>,
Serializable {
    public static final long serialVersionUID = 1L;
    private final Map<K, Set<V>> keyToValue;
    private final Map<V, Set<K>> valueToKey;

    public static <K, V> BiSetMultimap<K, V> create() {
        return new BiLinkedHashMultimap<K, V>();
    }

    public static <K, V> BiSetMultimap<K, V> create(BiSetMultimap<K, V> map) {
        return new BiLinkedHashMultimap<K, V>(map);
    }

    public BiLinkedHashMultimap() {
        this.keyToValue = new LinkedHashMap<K, Set<V>>();
        this.valueToKey = new HashMap<V, Set<K>>();
    }

    public BiLinkedHashMultimap(BiSetMultimap<K, V> map) {
        this.keyToValue = new LinkedHashMap<K, Set<Set<V>>>(map.keyToValue());
        this.valueToKey = new HashMap<Set<K>, Set<V>>(map.valueToKey());
    }

    @Override
    public void clear() {
        this.keyToValue.clear();
        this.valueToKey.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValue.containsKey(key) && !this.get(key).isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.keyToValue.containsValue(value) && !this.getInverse(value).isEmpty();
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        return this.keyToValue.getOrDefault(key, Collections.emptySet()).contains(value);
    }

    @Override
    public Set<V> get(K key) {
        return this.keyToValue.getOrDefault(key, Collections.emptySet());
    }

    @Override
    public Set<K> getInverse(V value) {
        return this.valueToKey.getOrDefault(value, Collections.emptySet());
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValue.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.keyToValue.keySet();
    }

    @Override
    public boolean put(K key, V value) {
        return this.keyToValue.computeIfAbsent(key, k -> new LinkedHashSet()).add(value) & this.valueToKey.computeIfAbsent((Set)value, (Function<Set, Set<Object>>)((Function<Object, Set>)v -> new HashSet())).add(key);
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        boolean result = true;
        for (V value : values) {
            result &= this.put(key, value);
        }
        return result;
    }

    @Override
    public boolean remove(K key, V value) {
        if (!this.containsEntry(key, value)) {
            return false;
        }
        this.removeFromKeyToValue(key, value);
        this.removeFromValueToKey(key, value);
        return true;
    }

    @Override
    public Set<V> removeAll(K key) {
        Set<V> removed = this.keyToValue.remove(key);
        if (removed == null) {
            return Collections.emptySet();
        }
        for (V r : removed) {
            this.removeFromValueToKey(key, r);
        }
        return removed;
    }

    @Override
    public Set<K> removeAllInverse(V value) {
        Set<K> removed1 = this.valueToKey.remove(value);
        if (removed1 == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<K> removed2 = new LinkedHashSet<K>();
        Iterator<Map.Entry<K, Set<V>>> iterator = this.keyToValue.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, Set<V>> e = iterator.next();
            K k = e.getKey();
            if (!removed1.contains(k)) continue;
            Set<V> values = e.getValue();
            values.remove(value);
            if (values.isEmpty()) {
                iterator.remove();
            }
            removed2.add(k);
        }
        return removed2;
    }

    @Override
    public int size() {
        return this.keyToValue.size();
    }

    @Override
    public Set<V> values() {
        return this.keyToValue.values().stream().flatMap(Collection::stream).collect(Collectors2.toLinkedHashSet());
    }

    @Override
    public Map<K, Set<V>> keyToValue() {
        return Collections.unmodifiableMap(this.keyToValue);
    }

    @Override
    public Map<V, Set<K>> valueToKey() {
        return Collections.unmodifiableMap(this.valueToKey);
    }

    private void removeFromKeyToValue(K key, V value) {
        this.keyToValue.computeIfPresent(key, (k, values) -> {
            values.remove(value);
            return values.isEmpty() ? null : values;
        });
    }

    private void removeFromValueToKey(K key, V value) {
        this.valueToKey.computeIfPresent((Set)value, (BiFunction<Set, Set<Object>, Set<Object>>)((BiFunction<Object, Set, Set>)(v, keys) -> {
            keys.remove(key);
            return keys.isEmpty() ? null : keys;
        }));
    }
}

