/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.unit;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.action.TransformActionContrib;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.unit.IUnit;
import org.metaborg.spoofax.core.syntax.JSGLRParserConfiguration;
import org.metaborg.spoofax.core.unit.AnalyzeContrib;
import org.metaborg.spoofax.core.unit.AnalyzeUnit;
import org.metaborg.spoofax.core.unit.AnalyzeUnitUpdate;
import org.metaborg.spoofax.core.unit.AnalyzeUpdateData;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnitUpdate;
import org.metaborg.spoofax.core.unit.ISpoofaxInputUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxTransformUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.metaborg.spoofax.core.unit.InputContrib;
import org.metaborg.spoofax.core.unit.InputUnit;
import org.metaborg.spoofax.core.unit.ParseContrib;
import org.metaborg.spoofax.core.unit.ParseUnit;
import org.metaborg.spoofax.core.unit.TransformContrib;
import org.metaborg.spoofax.core.unit.TransformUnit;
import org.metaborg.spoofax.core.unit.Unit;
import org.metaborg.spoofax.core.unit.UnitWrapper;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class UnitService
implements ISpoofaxUnitService {
    private final ITermFactory termFactory;

    @Inject
    public UnitService(ITermFactory termFactory) {
        this.termFactory = termFactory;
    }

    private Unit unit() {
        return new Unit();
    }

    private Unit unit(FileObject source) {
        return new Unit(source);
    }

    @Override
    public ISpoofaxInputUnit inputUnit(FileObject source, String text, ILanguageImpl langImpl, @Nullable ILanguageImpl dialect, @Nullable JSGLRParserConfiguration config) {
        Unit unit = this.unit(source);
        InputContrib contrib = new InputContrib(text, langImpl, dialect, config);
        InputUnit inputUnit = new InputUnit(unit, contrib);
        return inputUnit;
    }

    @Override
    public ISpoofaxInputUnit inputUnit(String text, ILanguageImpl langImpl, @Nullable ILanguageImpl dialect, @Nullable JSGLRParserConfiguration config) {
        Unit unit = this.unit();
        InputContrib contrib = new InputContrib(text, langImpl, dialect, config);
        InputUnit inputUnit = new InputUnit(unit, contrib);
        return inputUnit;
    }

    @Override
    public ISpoofaxInputUnit inputUnit(FileObject source, String text, ILanguageImpl langImpl, @Nullable ILanguageImpl dialect) {
        return this.inputUnit(source, text, langImpl, dialect, null);
    }

    @Override
    public ISpoofaxInputUnit inputUnit(String text, ILanguageImpl langImpl, @Nullable ILanguageImpl dialect) {
        return this.inputUnit(text, langImpl, dialect, null);
    }

    @Override
    public ISpoofaxInputUnit emptyInputUnit(FileObject source, ILanguageImpl langImpl, @Nullable ILanguageImpl dialect) {
        Unit unit = this.unit(source);
        InputContrib contrib = new InputContrib(langImpl, dialect);
        InputUnit inputUnit = new InputUnit(unit, contrib);
        return inputUnit;
    }

    @Override
    public ISpoofaxInputUnit emptyInputUnit(ILanguageImpl langImpl, @Nullable ILanguageImpl dialect) {
        Unit unit = this.unit();
        InputContrib contrib = new InputContrib(langImpl, dialect);
        InputUnit inputUnit = new InputUnit(unit, contrib);
        return inputUnit;
    }

    @Override
    public ISpoofaxParseUnit parseUnit(ISpoofaxInputUnit input, ParseContrib contrib) {
        if (!(input instanceof UnitWrapper)) {
            throw new MetaborgRuntimeException("Input unit is not a SpoofaxUnitWrapper, cannot create a parse unit");
        }
        UnitWrapper wrapper = (UnitWrapper)((Object)input);
        ParseUnit parseUnit = new ParseUnit(wrapper.unit, contrib, input);
        return parseUnit;
    }

    @Override
    public ISpoofaxParseUnit emptyParseUnit(ISpoofaxInputUnit input) {
        return this.parseUnit(input, new ParseContrib(this.termFactory.makeTuple(new IStrategoTerm[0])));
    }

    @Override
    public ISpoofaxAnalyzeUnit analyzeUnit(ISpoofaxParseUnit input, AnalyzeContrib contrib, IContext context) {
        if (!(input instanceof UnitWrapper)) {
            throw new MetaborgRuntimeException("Input unit is not a SpoofaxUnitWrapper, cannot create an analyze unit");
        }
        UnitWrapper wrapper = (UnitWrapper)((Object)input);
        AnalyzeUnit analyzeUnit = new AnalyzeUnit(wrapper.unit, contrib, input, context);
        return analyzeUnit;
    }

    @Override
    public ISpoofaxAnalyzeUnit emptyAnalyzeUnit(ISpoofaxParseUnit input, IContext context) {
        return this.analyzeUnit(input, new AnalyzeContrib(), context);
    }

    @Override
    public ISpoofaxAnalyzeUnitUpdate analyzeUnitUpdate(FileObject source, AnalyzeUpdateData contrib, IContext context) {
        return new AnalyzeUnitUpdate(source, contrib);
    }

    @Override
    public ISpoofaxAnalyzeUnitUpdate emptyAnalyzeUnitUpdate(FileObject source, IContext context) {
        return this.analyzeUnitUpdate(source, new AnalyzeUpdateData(), context);
    }

    @Override
    public <I extends IUnit> ISpoofaxTransformUnit<I> transformUnit(I input, TransformContrib contrib, IContext context, TransformActionContrib action) {
        if (!(input instanceof UnitWrapper)) {
            throw new MetaborgRuntimeException("Input unit is not a SpoofaxUnitWrapper, cannot create a transform unit");
        }
        UnitWrapper wrapper = (UnitWrapper)input;
        TransformUnit<I> analyzeUnit = new TransformUnit<I>(wrapper.unit, contrib, input, context, action);
        return analyzeUnit;
    }

    @Override
    public ISpoofaxTransformUnit<ISpoofaxParseUnit> emptyTransformUnit(ISpoofaxParseUnit input, IContext context, TransformActionContrib action) {
        return this.transformUnit(input, new TransformContrib(), context, action);
    }

    @Override
    public ISpoofaxTransformUnit<ISpoofaxAnalyzeUnit> emptyTransformUnit(ISpoofaxAnalyzeUnit input, IContext context, TransformActionContrib action) {
        return this.transformUnit(input, new TransformContrib(), context, action);
    }
}

