/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.parsetable.IParseTable;
import org.metaborg.parsetable.ParseTableReader;
import org.metaborg.sdf2table.io.ParseTableIO;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.metaborg.spoofax.core.syntax.IParseTableProvider;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.io.binary.TermReader;

public class JSGLR2FileParseTableProvider
implements IParseTableProvider {
    private final FileObject resource;
    private final ITermFactory termFactory;
    private IParseTable parseTable;

    public JSGLR2FileParseTableProvider(FileObject resource, ITermFactory termFactory) {
        this.resource = resource;
        this.termFactory = termFactory;
    }

    @Override
    public IParseTable parseTable() throws IOException {
        if (this.parseTable != null) {
            return this.parseTable;
        }
        this.resource.refresh();
        if (!this.resource.exists()) {
            throw new IOException("Could not load parse table from " + this.resource + ", file does not exist");
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = this.resource.getContent().getInputStream();){
                TermReader termReader = new TermReader(this.termFactory);
                IStrategoTerm parseTableTerm = termReader.parseFromStream(stream);
                FileObject persistedTable = this.resource.getParent().resolveFile("table.bin");
                this.parseTable = new ParseTableReader().read(parseTableTerm);
                if ((this.parseTable.totalStates() == 0 || this.parseTable.isLayoutSensitive()) && persistedTable.exists()) {
                    ParseTableIO ptg = new ParseTableIO(persistedTable.getContent().getInputStream(), true);
                    ParseTable parseTableFromSerializable = ptg.getParseTable();
                    return parseTableFromSerializable;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException("Could not load parse table from " + this.resource, e);
        }
        return this.parseTable;
    }
}

