/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.util.log.Level;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.PrintStreamWriter;

public class ResourceAgent
extends IOAgent {
    private final IResourceService resourceService;
    private final FileObject tempDir;
    private final Map<Integer, ResourceHandle> openFiles = new HashMap<Integer, ResourceHandle>();
    private final OutputStream stdout;
    private final Writer stdoutWriter;
    private final OutputStream stderr;
    private final Writer stderrWriter;
    private FileObject workingDir;
    private FileObject definitionDir;
    private boolean acceptDirChanges = true;

    public static OutputStream defaultStdout(String ... excludePatterns) {
        return LoggerUtils.stream(LoggerUtils.logger("stdout"), Level.Info, excludePatterns);
    }

    public static OutputStream defaultStderr(String ... excludePatterns) {
        return LoggerUtils.stream(LoggerUtils.logger("stderr"), Level.Info, excludePatterns);
    }

    public ResourceAgent(IResourceService resourceService) {
        this(resourceService, resourceService.resolve(System.getProperty("user.dir")));
    }

    public ResourceAgent(IResourceService resourceService, FileObject initialDir) {
        this(resourceService, initialDir, ResourceAgent.defaultStdout(new String[0]));
    }

    public ResourceAgent(IResourceService resourceService, FileObject initialDir, OutputStream stdout) {
        this(resourceService, initialDir, stdout, ResourceAgent.defaultStderr(new String[0]));
    }

    public ResourceAgent(IResourceService resourceService, FileObject initialDir, OutputStream stdout, OutputStream stderr) {
        this.resourceService = resourceService;
        this.tempDir = resourceService.resolve(System.getProperty("java.io.tmpdir"));
        this.workingDir = initialDir;
        this.definitionDir = initialDir;
        this.stdout = stdout;
        this.stdoutWriter = new PrintStreamWriter(new PrintStream(stdout));
        this.stderr = stderr;
        this.stderrWriter = new PrintStreamWriter(new PrintStream(stderr));
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir.getName().getURI();
    }

    public FileObject getWorkingDirResource() {
        return this.workingDir;
    }

    @Override
    public String getDefinitionDir() {
        return this.definitionDir.getName().getURI();
    }

    public FileObject getDefinitionDirResource() {
        return this.definitionDir;
    }

    @Override
    public String getTempDir() {
        return this.tempDir.getName().getURI();
    }

    public FileObject getTempDirResource() {
        return this.tempDir;
    }

    @Override
    public void setWorkingDir(String newWorkingDir) throws IOException {
        if (!this.acceptDirChanges) {
            return;
        }
        this.workingDir = this.resourceService.resolve(this.workingDir, newWorkingDir);
    }

    public void setAbsoluteWorkingDir(FileObject dir) {
        this.workingDir = dir;
    }

    @Override
    public void setDefinitionDir(String newDefinitionDir) {
        if (!this.acceptDirChanges) {
            return;
        }
        this.definitionDir = this.resourceService.resolve(this.definitionDir, newDefinitionDir);
    }

    public void setAbsoluteDefinitionDir(FileObject dir) {
        this.definitionDir = dir;
    }

    @Override
    public Writer getWriter(int fd) {
        if (fd == 1) {
            return this.stdoutWriter;
        }
        if (fd == 2) {
            return this.stderrWriter;
        }
        ResourceHandle handle = this.openFiles.get(fd);
        if (handle.writer == null) {
            assert (handle.outputStream == null);
            try {
                handle.writer = new BufferedWriter(new OutputStreamWriter(this.internalGetOutputStream(fd), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return handle.writer;
    }

    @Override
    public OutputStream internalGetOutputStream(int fd) {
        if (fd == 1) {
            return this.stdout;
        }
        if (fd == 2) {
            return this.stderr;
        }
        ResourceHandle handle = this.openFiles.get(fd);
        if (handle.outputStream == null) {
            assert (handle.writer == null);
            try {
                handle.outputStream = handle.resource.getContent().getOutputStream();
            }
            catch (FileSystemException e) {
                throw new RuntimeException("Could not get output stream for resource", e);
            }
        }
        return handle.outputStream;
    }

    @Override
    public void writeChar(int fd, int c) throws IOException {
        if (fd == 1 || fd == 2) {
            this.getWriter(fd).append((char)c);
        } else {
            this.getWriter(fd).append((char)c);
        }
    }

    @Override
    public boolean closeRandomAccessFile(int fd) throws InterpreterException {
        if (fd == 1 || fd == 2 || fd == 0) {
            return true;
        }
        ResourceHandle handle = this.openFiles.remove(fd);
        if (handle == null) {
            return true;
        }
        try {
            if (handle.writer != null) {
                handle.writer.close();
            }
            if (handle.outputStream != null) {
                handle.outputStream.close();
            }
            handle.resource.getContent().close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close resource", e);
        }
        return true;
    }

    @Override
    public void closeAllFiles() {
        for (ResourceHandle handle : this.openFiles.values()) {
            try {
                if (handle.writer != null) {
                    handle.writer.close();
                }
                if (handle.outputStream != null) {
                    handle.outputStream.close();
                }
                handle.resource.getContent().close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close resource", e);
            }
        }
        this.openFiles.clear();
    }

    @Override
    public int openRandomAccessFile(String fn, String mode) throws IOException {
        boolean appendMode = mode.indexOf(97) >= 0;
        boolean writeMode = appendMode || mode.indexOf(119) >= 0;
        boolean clearFile = false;
        FileObject resource = this.resourceService.resolve(this.workingDir, fn);
        if (writeMode) {
            if (!resource.exists()) {
                resource.createFile();
            } else if (!appendMode) {
                clearFile = true;
            }
        }
        if (clearFile) {
            resource.delete();
            resource.createFile();
        }
        this.openFiles.put(this.fileCounter, new ResourceHandle(resource));
        return this.fileCounter++;
    }

    @Override
    public InputStream internalGetInputStream(int fd) {
        if (fd == 0) {
            return this.stdin;
        }
        ResourceHandle handle = this.openFiles.get(fd);
        if (handle.inputStream == null) {
            try {
                handle.inputStream = handle.resource.getContent().getInputStream();
            }
            catch (FileSystemException e) {
                throw new RuntimeException("Could not get input stream for resource", e);
            }
        }
        return handle.inputStream;
    }

    @Override
    public Reader getReader(int fd) {
        if (fd == 0) {
            return this.stdinReader;
        }
        ResourceHandle handle = this.openFiles.get(fd);
        try {
            if (handle.reader == null) {
                handle.reader = new BufferedReader(new InputStreamReader(this.internalGetInputStream(fd), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not get reader for resource", e);
        }
        return handle.reader;
    }

    @Override
    public String readString(int fd) throws IOException {
        char[] buffer = new char[2048];
        StringBuilder result = new StringBuilder();
        Reader reader = this.getReader(fd);
        int read = 0;
        while (read != -1) {
            result.append(buffer, 0, read);
            read = reader.read(buffer);
        }
        return result.toString();
    }

    @Override
    public String[] readdir(String fn) {
        try {
            FileObject resource = this.resourceService.resolve(this.workingDir, fn);
            if (!resource.exists() || resource.getType() == FileType.FILE) {
                return new String[0];
            }
            FileName name = resource.getName();
            FileObject[] children = resource.getChildren();
            String[] strings = new String[children.length];
            int i = 0;
            while (i < children.length) {
                FileName absName = children[i].getName();
                strings[i] = name.getRelativeName(absName);
                ++i;
            }
            return strings;
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not list contents of directory " + fn, e);
        }
    }

    @Override
    public void printError(String error) {
        try {
            this.getWriter(2).write(String.valueOf(error) + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public InputStream openInputStream(String fn, boolean isDefinitionFile) throws FileNotFoundException {
        FileObject dir = isDefinitionFile ? this.definitionDir : this.workingDir;
        try {
            FileObject file = this.resourceService.resolve(dir, fn);
            return file.getContent().getInputStream();
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not get input stream for resource", e);
        }
    }

    @Override
    public OutputStream openFileOutputStream(String fn) throws FileNotFoundException {
        try {
            return this.resourceService.resolve(this.workingDir, fn).getContent().getOutputStream();
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not get output stream for resource", e);
        }
    }

    @Override
    public File openFile(String fn) {
        FileObject resource = this.resourceService.resolve(this.workingDir, fn);
        File localResource = this.resourceService.localPath(resource);
        if (localResource == null) {
            File localWorkingDir = this.resourceService.localPath(this.workingDir);
            if (localWorkingDir == null) {
                return new File(fn);
            }
            return new File(this.getAbsolutePath(localWorkingDir.getPath(), fn));
        }
        return localResource;
    }

    @Override
    public String createTempFile(String prefix) throws IOException {
        File tempFile = File.createTempFile(prefix, null);
        tempFile.deleteOnExit();
        return tempFile.getPath();
    }

    @Override
    public String createTempDir(String prefix) throws IOException {
        File result;
        do {
            result = File.createTempFile(prefix, null);
            result.delete();
        } while (!result.mkdir());
        result.deleteOnExit();
        return result.getPath();
    }

    @Override
    public boolean mkdir(String dn) {
        try {
            FileObject resource = this.resourceService.resolve(this.workingDir, dn);
            boolean created = !resource.exists();
            resource.createFolder();
            return created;
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not create directories", e);
        }
    }

    @Override
    @Deprecated
    public boolean mkDirs(String dn) {
        return this.mkdir(dn);
    }

    @Override
    public boolean rmdir(String dn) {
        try {
            FileObject resource = this.resourceService.resolve(this.workingDir, dn);
            return resource.delete((FileSelector)new AllFileSelector()) > 0;
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not delete directory " + dn, e);
        }
    }

    @Override
    public boolean exists(String fn) {
        try {
            FileObject resource = this.resourceService.resolve(this.workingDir, fn);
            return resource.exists();
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not check if file " + fn + " exists", e);
        }
    }

    @Override
    public boolean readable(String fn) {
        try {
            FileObject resource = this.resourceService.resolve(this.workingDir, fn);
            return resource.isReadable();
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not check if file " + fn + " is readable", e);
        }
    }

    @Override
    public boolean writable(String fn) {
        try {
            FileObject resource = this.resourceService.resolve(this.workingDir, fn);
            return resource.isWriteable();
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not check if file " + fn + " is writeable", e);
        }
    }

    @Override
    public boolean isDirectory(String fn) {
        try {
            FileObject resource = this.resourceService.resolve(this.workingDir, fn);
            FileType type = resource.getType();
            return type == FileType.FOLDER || type == FileType.FILE_OR_FOLDER;
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not check if file " + fn + " is a directory", e);
        }
    }

    private static class ResourceHandle {
        public final FileObject resource;
        public Reader reader;
        public Writer writer;
        public InputStream inputStream;
        public OutputStream outputStream;

        ResourceHandle(FileObject resource) {
            this.resource = resource;
        }
    }
}

