/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.language.dialect;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.language.ComponentCreationConfig;
import org.metaborg.core.language.IFacet;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.IdentificationFacet;
import org.metaborg.core.language.LanguageContributionIdentifier;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.language.ResourceExtensionFacet;
import org.metaborg.core.language.dialect.IDialectService;
import org.metaborg.spoofax.core.language.dialect.MetaFileIdentifier;
import org.metaborg.spoofax.core.syntax.SyntaxFacet;
import org.metaborg.util.collection.SetMultimap;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class DialectService
implements IDialectService {
    private static final ILogger logger = LoggerUtils.logger(DialectService.class);
    private final ILanguageService languageService;
    private final Map<String, ILanguageImpl> nameToDialect = new HashMap<String, ILanguageImpl>();
    private final Map<ILanguageImpl, ILanguageImpl> dialectToBase = new HashMap<ILanguageImpl, ILanguageImpl>();
    private final SetMultimap<ILanguageImpl, ILanguageImpl> baseLanguageToDialects = new SetMultimap();

    @Inject
    public DialectService(ILanguageService languageService) {
        this.languageService = languageService;
    }

    @Override
    @Nullable
    public String dialectName(ILanguageImpl dialect) {
        ILanguageImpl base = this.getBase(dialect);
        if (base == null) {
            return null;
        }
        return dialect.id().id.substring((String.valueOf(base.id().id) + "-Dialect-").length());
    }

    @Override
    public boolean hasDialect(String name) {
        return this.nameToDialect.containsKey(name);
    }

    @Override
    @Nullable
    public ILanguageImpl getDialect(String name) {
        return this.nameToDialect.get(name);
    }

    @Override
    public Iterable<ILanguageImpl> getDialects(ILanguageImpl base) {
        return this.baseLanguageToDialects.get(base);
    }

    @Override
    public ILanguageImpl getBase(ILanguageImpl dialect) {
        return this.dialectToBase.get(dialect);
    }

    @Override
    public ILanguageImpl add(String name, FileObject location, ILanguageImpl base, IFacet syntaxFacet) {
        if (this.nameToDialect.containsKey(name)) {
            String message = String.format("Dialect with name %s already exists", name);
            logger.error(message);
            throw new MetaborgRuntimeException(message);
        }
        logger.debug("Adding dialect {} from {} with {} as base", name, location, base);
        ILanguageImpl dialect = this.createDialect(name, location, base, syntaxFacet, true, true);
        this.nameToDialect.put(name, dialect);
        this.dialectToBase.put(dialect, base);
        this.baseLanguageToDialects.put(base, dialect);
        return dialect;
    }

    @Override
    public ILanguageImpl update(String name, IFacet syntaxFacet) {
        ILanguageImpl dialect = this.nameToDialect.get(name);
        if (dialect == null) {
            String message = String.format("Dialect with name %s does not exist", name);
            logger.error(message);
            throw new MetaborgRuntimeException(message);
        }
        logger.debug("Updating syntax facet for dialect {}", name);
        FileObject location = dialect.components().iterator().next().location();
        ILanguageImpl newDialect = this.createDialect(name, location, dialect, syntaxFacet, false, false);
        this.nameToDialect.put(name, newDialect);
        return newDialect;
    }

    @Override
    public Iterable<ILanguageImpl> update(ILanguageImpl base) {
        Object dialects = this.baseLanguageToDialects.get(base);
        if (dialects.isEmpty()) {
            return dialects;
        }
        logger.debug("Updating base language for {} dialects", dialects.size());
        ArrayList<ILanguageImpl> newDialects = new ArrayList<ILanguageImpl>(dialects.size());
        for (ILanguageImpl dialect : dialects) {
            ILanguageImpl newDialect;
            String name = dialect.belongsTo().name();
            FileObject location = dialect.components().iterator().next().location();
            SyntaxFacet syntaxFacet = dialect.facet(SyntaxFacet.class);
            try {
                newDialect = this.createDialect(name, location, base, syntaxFacet, true, true);
            }
            catch (IllegalStateException e) {
                String message = String.format("Error updating dialect %s", name);
                logger.error(message, e);
                continue;
            }
            this.nameToDialect.put(name, newDialect);
            newDialects.add(newDialect);
        }
        return newDialects;
    }

    @Override
    public ILanguageImpl remove(String name) {
        ILanguageImpl dialect = this.nameToDialect.remove(name);
        if (dialect == null) {
            String message = String.format("Dialect with name %s does not exist", name);
            logger.error(message);
            throw new MetaborgRuntimeException(message);
        }
        logger.debug("Removing dialect {}", name);
        ILanguageImpl base = this.dialectToBase.remove(dialect);
        this.baseLanguageToDialects.remove(base, dialect);
        try {
            ILanguageComponent dialectComponent = dialect.components().iterator().next();
            this.languageService.remove(dialectComponent);
        }
        catch (IllegalStateException e) {
            String message = String.format("Error removing dialect %s", name);
            logger.error(message, e);
        }
        return dialect;
    }

    @Override
    public Iterable<ILanguageImpl> remove(ILanguageImpl base) {
        Object dialects = this.baseLanguageToDialects.get(base);
        if (dialects.isEmpty()) {
            return dialects;
        }
        logger.debug("Removing {} dialects for base language {}", dialects.size(), base);
        ArrayList<ILanguageImpl> removedDialects = new ArrayList<ILanguageImpl>(dialects.size());
        for (ILanguageImpl dialect : dialects) {
            String name = dialect.belongsTo().name();
            this.nameToDialect.remove(name);
            this.dialectToBase.remove(dialect);
            this.baseLanguageToDialects.remove(base, dialect);
            try {
                ILanguageComponent dialectComponent = dialect.components().iterator().next();
                this.languageService.remove(dialectComponent);
            }
            catch (IllegalStateException e) {
                String message = String.format("Error removing dialect %s", name);
                logger.error(message, e);
                continue;
            }
            removedDialects.add(dialect);
        }
        return removedDialects;
    }

    private ILanguageImpl createDialect(String name, FileObject location, ILanguageImpl base, IFacet syntaxFacet, boolean replaceIdentification, boolean appendDialectName) {
        LanguageIdentifier baseId = base.id();
        String dialectId = appendDialectName ? String.valueOf(baseId.id) + "-Dialect-" + name : baseId.id;
        LanguageIdentifier id = new LanguageIdentifier(baseId.groupId, dialectId, baseId.version);
        ILanguageComponentConfig config = base.components().iterator().next().config();
        ComponentCreationConfig creationConfig = this.languageService.create(id, location, Iterables2.singleton(new LanguageContributionIdentifier(id, name)), config);
        for (IFacet facet : base.facets()) {
            if (facet instanceof IdentificationFacet && replaceIdentification) {
                creationConfig.addFacet(new IdentificationFacet(new MetaFileIdentifier((IdentificationFacet)facet)));
                continue;
            }
            if (facet instanceof SyntaxFacet || facet instanceof ResourceExtensionFacet) continue;
            creationConfig.addFacet(facet);
        }
        creationConfig.addFacet(syntaxFacet);
        ILanguageComponent dialectComponent = this.languageService.add(creationConfig);
        ILanguageImpl dialect = dialectComponent.contributesTo().iterator().next();
        return dialect;
    }
}

