/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.dynamicclassloading;

import java.util.LinkedHashSet;
import java.util.Set;
import mb.util.vfs2.resource.ResourceUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.spoofax.core.dynamicclassloading.DynamicClassLoadingFacet;
import org.metaborg.spoofax.core.esv.ESVReader;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;

public class DynamicClassLoadingFacetFromESV {
    private static final ILogger logger = LoggerUtils.logger(DynamicClassLoadingFacetFromESV.class);

    public static DynamicClassLoadingFacet create(IStrategoAppl esv, FileObject location) throws FileSystemException {
        Set<FileObject> strategoFiles = DynamicClassLoadingFacetFromESV.providerResources(esv, location);
        LinkedHashSet<FileObject> jarFiles = new LinkedHashSet<FileObject>();
        for (FileObject strategoFile : strategoFiles) {
            String extension;
            switch (extension = strategoFile.getName().getExtension()) {
                case "jar": {
                    jarFiles.add(strategoFile);
                    break;
                }
                default: {
                    logger.warn("Stratego provider file {} has unknown extension {}, ignoring", strategoFile, extension);
                }
                case "ctree": 
            }
        }
        return new DynamicClassLoadingFacet(jarFiles);
    }

    private static Set<FileObject> providerResources(IStrategoAppl esv, FileObject location) throws FileSystemException {
        LinkedHashSet<FileObject> attachedFiles = new LinkedHashSet<FileObject>();
        for (IStrategoAppl s : ESVReader.collectTerms(esv, "SemanticProvider")) {
            attachedFiles.add(ResourceUtils.resolveFile(location, ESVReader.termContents(s)));
        }
        return attachedFiles;
    }
}

